/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.response;

import io.github.jopenlibs.vault.api.Logical;
import io.github.jopenlibs.vault.json.Json;
import io.github.jopenlibs.vault.json.JsonArray;
import io.github.jopenlibs.vault.json.JsonObject;
import io.github.jopenlibs.vault.json.JsonValue;
import io.github.jopenlibs.vault.response.DataMetadata;
import io.github.jopenlibs.vault.response.VaultResponse;
import io.github.jopenlibs.vault.response.WrapResponse;
import io.github.jopenlibs.vault.rest.RestResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogicalResponse
extends VaultResponse {
    private Map<String, String> data = new HashMap<String, String>();
    private List<String> listData = new ArrayList<String>();
    private JsonObject dataObject = null;
    private String leaseId;
    private WrapResponse wrapResponse;
    private Boolean renewable;
    private Long leaseDuration;
    private final Map<String, String> dataMetadata = new HashMap<String, String>();

    public LogicalResponse(RestResponse restResponse, int retries, Logical.logicalOperations operation) {
        super(restResponse, retries);
        this.parseMetadataFields();
        this.parseResponseData(operation);
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public List<String> getListData() {
        return this.listData;
    }

    public JsonObject getDataObject() {
        return this.dataObject;
    }

    public String getLeaseId() {
        return this.leaseId;
    }

    public Boolean getRenewable() {
        return this.renewable;
    }

    public Long getLeaseDuration() {
        return this.leaseDuration;
    }

    public WrapResponse getWrapResponse() {
        return this.wrapResponse;
    }

    public DataMetadata getDataMetadata() {
        return new DataMetadata(this.dataMetadata);
    }

    private void parseMetadataFields() {
        try {
            String jsonString = new String(this.getRestResponse().getBody(), StandardCharsets.UTF_8);
            JsonObject jsonObject = Json.parse(jsonString).asObject();
            this.leaseId = jsonObject.get("lease_id").asString();
            this.renewable = jsonObject.get("renewable").asBoolean();
            this.leaseDuration = jsonObject.get("lease_duration").asLong();
            this.wrapResponse = new WrapResponse(this.getRestResponse(), this.getRetries());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseResponseData(Logical.logicalOperations operation) {
        try {
            JsonValue metadataValue;
            String jsonString = new String(this.getRestResponse().getBody(), StandardCharsets.UTF_8);
            JsonObject jsonObject = Json.parse(jsonString).asObject();
            if (operation.equals((Object)Logical.logicalOperations.readV2) && null != (metadataValue = (jsonObject = jsonObject.get("data").asObject()).get("metadata"))) {
                this.parseJsonIntoMap(metadataValue.asObject(), this.dataMetadata);
            }
            this.data = new HashMap<String, String>();
            this.dataObject = jsonObject.get("data").asObject();
            this.parseJsonIntoMap(this.dataObject, this.data);
            if ((operation.equals((Object)Logical.logicalOperations.listV1) || operation.equals((Object)Logical.logicalOperations.listV2)) && this.getRestResponse().getStatus() != 404 && this.data.get("keys") != null) {
                JsonArray keys = Json.parse(this.data.get("keys")).asArray();
                for (int index = 0; index < keys.size(); ++index) {
                    this.listData.add(keys.get(index).asString());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseJsonIntoMap(JsonObject jsonObject, Map<String, String> map) {
        for (JsonObject.Member member : jsonObject) {
            JsonValue jsonValue = member.getValue();
            if (jsonValue == null || jsonValue.isNull()) continue;
            if (jsonValue.isString()) {
                map.put(member.getName(), jsonValue.asString());
                continue;
            }
            map.put(member.getName(), jsonValue.toString());
        }
    }
}

