/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.api.pki;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RoleOptions
implements Serializable {
    private String ttl;
    private String maxTtl;
    private Boolean allowLocalhost;
    private List<String> allowedDomains;
    private Boolean allowBareDomains;
    private Boolean allowSubdomains;
    private Boolean allowAnyName;
    private Boolean enforceHostnames;
    private Boolean allowIpSans;
    private Boolean serverFlag;
    private Boolean clientFlag;
    private Boolean codeSigningFlag;
    private Boolean emailProtectionFlag;
    private String keyType;
    private Long keyBits;
    private Boolean useCsrCommonName;
    private Boolean allowSpiffename;
    private Boolean useCsrSans;
    private List<String> keyUsage;

    public RoleOptions ttl(String ttl) {
        this.ttl = ttl;
        return this;
    }

    public RoleOptions maxTtl(String maxTtl) {
        this.maxTtl = maxTtl;
        return this;
    }

    public RoleOptions allowLocalhost(Boolean allowLocalhost) {
        this.allowLocalhost = allowLocalhost;
        return this;
    }

    public RoleOptions allowedDomains(List<String> allowedDomains) {
        if (allowedDomains != null) {
            this.allowedDomains = new ArrayList<String>();
            this.allowedDomains.addAll(allowedDomains);
        }
        return this;
    }

    public RoleOptions allowBareDomains(Boolean allowBareDomains) {
        this.allowBareDomains = allowBareDomains;
        return this;
    }

    public RoleOptions allowSubdomains(Boolean allowSubdomains) {
        this.allowSubdomains = allowSubdomains;
        return this;
    }

    public RoleOptions allowSpiffeName(Boolean allowSpiffename) {
        this.allowSpiffename = allowSpiffename;
        return this;
    }

    public RoleOptions allowAnyName(Boolean allowAnyName) {
        this.allowAnyName = allowAnyName;
        return this;
    }

    public RoleOptions enforceHostnames(Boolean enforceHostnames) {
        this.enforceHostnames = enforceHostnames;
        return this;
    }

    public RoleOptions allowIpSans(Boolean allowIpSans) {
        this.allowIpSans = allowIpSans;
        return this;
    }

    public RoleOptions serverFlag(Boolean serverFlag) {
        this.serverFlag = serverFlag;
        return this;
    }

    public RoleOptions clientFlag(Boolean clientFlag) {
        this.clientFlag = clientFlag;
        return this;
    }

    public RoleOptions codeSigningFlag(Boolean codeSigningFlag) {
        this.codeSigningFlag = codeSigningFlag;
        return this;
    }

    public RoleOptions emailProtectionFlag(Boolean emailProtectionFlag) {
        this.emailProtectionFlag = emailProtectionFlag;
        return this;
    }

    public RoleOptions keyType(String keyType) {
        this.keyType = keyType;
        return this;
    }

    public RoleOptions keyBits(Long keyBits) {
        this.keyBits = keyBits;
        return this;
    }

    public RoleOptions useCsrCommonName(Boolean useCsrCommonName) {
        this.useCsrCommonName = useCsrCommonName;
        return this;
    }

    public RoleOptions useCsrSans(Boolean useCsrSans) {
        this.useCsrSans = useCsrSans;
        return this;
    }

    public String getTtl() {
        return this.ttl;
    }

    public String getMaxTtl() {
        return this.maxTtl;
    }

    public Boolean getAllowLocalhost() {
        return this.allowLocalhost;
    }

    public List<String> getAllowedDomains() {
        if (this.allowedDomains == null) {
            return null;
        }
        return new ArrayList<String>(this.allowedDomains);
    }

    public Boolean getAllowBareDomains() {
        return this.allowBareDomains;
    }

    public Boolean getAllowSubdomains() {
        return this.allowSubdomains;
    }

    public Boolean getAllowAnyName() {
        return this.allowAnyName;
    }

    public Boolean getEnforceHostnames() {
        return this.enforceHostnames;
    }

    public Boolean getAllowIpSans() {
        return this.allowIpSans;
    }

    public Boolean getServerFlag() {
        return this.serverFlag;
    }

    public Boolean getClientFlag() {
        return this.clientFlag;
    }

    public Boolean getCodeSigningFlag() {
        return this.codeSigningFlag;
    }

    public Boolean getEmailProtectionFlag() {
        return this.emailProtectionFlag;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public Long getKeyBits() {
        return this.keyBits;
    }

    public Boolean getUseCsrCommonName() {
        return this.useCsrCommonName;
    }

    public Boolean getUseCsrSans() {
        return this.useCsrSans;
    }

    public Boolean getAllowSpiffename() {
        return this.allowSpiffename;
    }

    public RoleOptions keyUsage(List<String> keyUsage) {
        this.keyUsage = keyUsage;
        return this;
    }

    public List<String> getKeyUsage() {
        return this.keyUsage;
    }
}

