/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault;

import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.VaultImpl;
import io.github.jopenlibs.vault.api.Auth;
import io.github.jopenlibs.vault.api.Debug;
import io.github.jopenlibs.vault.api.Logical;
import io.github.jopenlibs.vault.api.database.Database;
import io.github.jopenlibs.vault.api.pki.Pki;
import io.github.jopenlibs.vault.api.sys.Leases;
import io.github.jopenlibs.vault.api.sys.Seal;
import io.github.jopenlibs.vault.api.sys.Sys;
import io.github.jopenlibs.vault.api.sys.mounts.Mounts;
import java.util.Map;

public interface Vault {
    public static Vault create(VaultConfig vaultConfig) {
        return new VaultImpl(vaultConfig);
    }

    public static Vault create(VaultConfig vaultConfig, Integer engineVersion) {
        return new VaultImpl(vaultConfig, engineVersion);
    }

    public static Vault create(VaultConfig vaultConfig, Boolean useSecretsEnginePathMap, Integer globalFallbackVersion) throws VaultException {
        return new VaultImpl(vaultConfig, useSecretsEnginePathMap, globalFallbackVersion);
    }

    public Vault withRetries(int var1, int var2);

    public Logical logical();

    public Auth auth();

    public Sys sys();

    public Pki pki();

    public Pki pki(String var1);

    public Database database();

    public Database database(String var1);

    public Leases leases();

    public Debug debug();

    public Mounts mounts();

    public Seal seal();

    public Map<String, String> getSecretEngineVersions();
}

