/*
 * Decompiled with CFR 0.152.
 */
package com.moyun365.commonutil;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.moyun365.commonutil.NetType;

public class NetUtil {
    private static final String TAG = "";

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity == null) {
            return false;
        }
        NetworkInfo[] info = connectivity.getAllNetworkInfo();
        if (info != null) {
            for (int i = 0; i < info.length; ++i) {
                if (info[i].getState() != NetworkInfo.State.CONNECTED) continue;
                return true;
            }
        }
        return false;
    }

    private static NetworkInfo getCurrentActiveNetworkInfo(Context context) {
        NetworkInfo networkInfo = null;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager != null) {
            networkInfo = connectivityManager.getActiveNetworkInfo();
            Log.d((String)TAG, (String)("Current Active Network : " + networkInfo));
        }
        return networkInfo;
    }

    public static NetType getCurrentNetType(Context context) {
        NetType type = NetType.NONE;
        NetworkInfo info = NetUtil.getCurrentActiveNetworkInfo(context);
        if (info == null) {
            return type;
        }
        if (info.getState() == NetworkInfo.State.CONNECTED) {
            String subTypeName;
            type = info.getType() == 1 ? NetType.WIFI : (info.getType() == 0 ? ((subTypeName = info.getSubtypeName().toUpperCase()).indexOf("GPRS") > -1 ? NetType.MOBILE_GPRS : (subTypeName.indexOf("EDGE") > -1 ? NetType.MOBILE_EDGE : NetType.MOBILE_3G)) : NetType.UNKNOW);
        } else if (info.getState() == NetworkInfo.State.CONNECTING) {
            type = NetType.UNKNOW;
            System.out.println("connecting " + info.getType());
        }
        return type;
    }
}

