/*
 * Decompiled with CFR 0.152.
 */
package com.moyun365.commonutil;

import android.content.Intent;
import android.os.Parcelable;
import java.io.Serializable;
import java.util.ArrayList;

public class IntentUtil {
    public static int getIntentIntByKey(Intent intent, String key) {
        return IntentUtil.getIntentIntByKey(intent, key, 0);
    }

    public static int getIntentIntByKey(Intent intent, String key, int defaultInt) {
        int result = 0;
        if (null != intent && intent.hasExtra(key)) {
            result = intent.getIntExtra(key, defaultInt);
        }
        return result;
    }

    public static long getIntentLongByKey(Intent intent, String key) {
        return IntentUtil.getIntentLongByKey(intent, key, 0);
    }

    public static long getIntentLongByKey(Intent intent, String key, int defaultInt) {
        long result = 0L;
        if (null != intent && intent.hasExtra(key)) {
            result = intent.getLongExtra(key, (long)defaultInt);
        }
        return result;
    }

    public static boolean getIntentBooleanByKey(Intent intent, String key) {
        return IntentUtil.getIntentBooleanByKey(intent, key, false);
    }

    public static boolean getIntentBooleanByKey(Intent intent, String key, boolean defaultValue) {
        boolean result = false;
        if (null != intent && intent.hasExtra(key)) {
            result = intent.getBooleanExtra(key, defaultValue);
        }
        return result;
    }

    public static String getIntentStringByKey(Intent intent, String key) {
        String result = "";
        if (null != intent && intent.hasExtra(key)) {
            result = intent.getStringExtra(key);
        }
        return result;
    }

    public static double getIntentDoubleByKey(Intent intent, String key) {
        double result = 0.0;
        if (null != intent && intent.hasExtra(key)) {
            result = intent.getDoubleExtra(key, 0.0);
        }
        return result;
    }

    public static Serializable getIntentObjectByKey(Intent intent, String key) {
        Serializable serializable = null;
        if (null != intent && intent.hasExtra(key)) {
            serializable = intent.getSerializableExtra(key);
        }
        return serializable;
    }

    public static ArrayList<String> getIntentStringArrayList(Intent intent, String key) {
        ArrayList strings = new ArrayList();
        if (null != intent && intent.hasExtra(key)) {
            strings = intent.getStringArrayListExtra(key);
        }
        return strings;
    }

    public static ArrayList<Integer> getIntentIntegerArrayList(Intent intent, String key) {
        ArrayList integers = new ArrayList();
        if (null != intent && intent.hasExtra(key)) {
            integers = intent.getIntegerArrayListExtra(key);
        }
        return integers;
    }

    public static boolean[] getIntentBooleanArrays(Intent intent, String key) {
        if (intent.hasExtra(key)) {
            return intent.getBooleanArrayExtra(key);
        }
        return new boolean[0];
    }

    public static Object getParcelableExtra(Intent intent, String key) {
        if (null == intent) {
            return null;
        }
        if (intent.hasExtra(key)) {
            return intent.getParcelableExtra(key);
        }
        return null;
    }

    public static <T extends Parcelable> ArrayList<T> getParcelableArrayListExtra(Intent intent, String key) {
        if (null == intent) {
            return null;
        }
        if (intent.hasExtra(key)) {
            return intent.getParcelableArrayListExtra(key);
        }
        return null;
    }
}

