/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"url", "source", "tags"})
public class Reference
implements Serializable {
    private static final long serialVersionUID = -224192309845772254L;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="source")
    private String source;
    @JsonProperty(value="tags")
    private List<String> tags;

    public Reference() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="I prefer to suppress these FindBugs warnings")
    public Reference(String url, String source, List<String> tags) {
        this.url = url;
        this.source = source;
        this.tags = tags;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="tags")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="I prefer to suppress these FindBugs warnings")
    public List<String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "Reference{url='" + this.url + "', source='" + this.source + "', tags=" + this.tags + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reference reference = (Reference)o;
        return Objects.equals(this.url, reference.url) && Objects.equals(this.source, reference.source) && Objects.equals(this.tags, reference.tags);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.source, this.tags);
    }
}

