/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.util.ExplicitThreadLocal;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.util.function.Supplier;
import java.util.logging.Logger;

public interface RandomAccessVectorValues {
    public static final Logger LOG = Logger.getLogger(RandomAccessVectorValues.class.getName());

    public int size();

    public int dimension();

    public VectorFloat<?> getVector(int var1);

    @Deprecated
    default public VectorFloat<?> vectorValue(int targetOrd) {
        return this.getVector(targetOrd);
    }

    default public void getVectorInto(int node, VectorFloat<?> destinationVector, int offset) {
        destinationVector.copyFrom(this.getVector(node), 0, offset, this.dimension());
    }

    public boolean isValueShared();

    public RandomAccessVectorValues copy();

    default public Supplier<RandomAccessVectorValues> threadLocalSupplier() {
        if (!this.isValueShared()) {
            return () -> this;
        }
        if (this instanceof AutoCloseable) {
            LOG.warning("RAVV is shared and implements AutoCloseable; threadLocalSupplier() may lead to leaks");
        }
        ExplicitThreadLocal<RandomAccessVectorValues> tl = ExplicitThreadLocal.withInitial(this::copy);
        return tl::get;
    }

    default public ScoreFunction.ExactScoreFunction rerankerFor(final VectorFloat<?> queryVector, final VectorSimilarityFunction vsf) {
        return new ScoreFunction.ExactScoreFunction(){
            private final VectorFloat<?> scratch;
            final /* synthetic */ RandomAccessVectorValues this$0;
            {
                this.this$0 = this$0;
                this.scratch = vts.createFloatVector(this.this$0.dimension());
            }

            @Override
            public float similarityTo(int node2) {
                this.this$0.getVectorInto(node2, this.scratch, 0);
                return vsf.compare(queryVector, this.scratch);
            }
        };
    }
}

