/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.vector.cnative;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class LibraryLoader {
    private LibraryLoader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean loadJvector() {
        try {
            System.loadLibrary("jvector");
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                String libName = System.mapLibraryName("jvector");
                File tmpLibFile = File.createTempFile(libName.substring(0, libName.lastIndexOf(46)), libName.substring(libName.lastIndexOf(46)));
                try (InputStream in = LibraryLoader.class.getResourceAsStream("/" + libName);
                     OutputStream out = Files.newOutputStream(tmpLibFile.toPath(), new OpenOption[0]);){
                    if (in == null) {
                        boolean bl = false;
                        return bl;
                    }
                    in.transferTo(out);
                    out.flush();
                }
                System.load(tmpLibFile.getAbsolutePath());
                return true;
            }
            catch (Exception | UnsatisfiedLinkError throwable) {
                return false;
            }
        }
    }
}

