/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.disk;

import io.github.jbellis.jvector.disk.IndexWriter;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;

public class SimpleWriter
implements IndexWriter {
    private final FileOutputStream fos;
    private final DataOutputStream dos;

    public SimpleWriter(Path path) throws IOException {
        this.fos = new FileOutputStream(path.toFile());
        this.dos = new DataOutputStream(this.fos);
    }

    @Override
    public long position() throws IOException {
        this.dos.flush();
        return this.fos.getChannel().position();
    }

    @Override
    public void write(int b) throws IOException {
        this.dos.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.dos.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.dos.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.dos.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.dos.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.dos.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.dos.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.dos.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.dos.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.dos.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.dos.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.dos.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.dos.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.dos.writeUTF(s);
    }

    @Override
    public void close() throws IOException {
        this.dos.flush();
        this.dos.close();
        this.fos.close();
    }
}

