/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.vector;

import io.github.jbellis.jvector.annotations.Experimental;
import io.github.jbellis.jvector.vector.MemorySegmentVectorProvider;
import io.github.jbellis.jvector.vector.NativeVectorUtilSupport;
import io.github.jbellis.jvector.vector.VectorUtilSupport;
import io.github.jbellis.jvector.vector.VectorizationProvider;
import io.github.jbellis.jvector.vector.cnative.LibraryLoader;
import io.github.jbellis.jvector.vector.cnative.NativeSimdOps;
import io.github.jbellis.jvector.vector.types.VectorTypeSupport;

@Experimental
public class NativeVectorizationProvider
extends VectorizationProvider {
    private final VectorUtilSupport vectorUtilSupport;
    private final VectorTypeSupport vectorTypeSupport;

    public NativeVectorizationProvider() {
        boolean libraryLoaded = LibraryLoader.loadJvector();
        if (!libraryLoaded) {
            throw new UnsupportedOperationException("Failed to load supporting native library.");
        }
        if (!NativeSimdOps.check_compatibility()) {
            throw new UnsupportedOperationException("Native SIMD operations are not supported on this platform due to missing CPU support.");
        }
        this.vectorUtilSupport = new NativeVectorUtilSupport();
        this.vectorTypeSupport = new MemorySegmentVectorProvider();
    }

    @Override
    public VectorUtilSupport getVectorUtilSupport() {
        return this.vectorUtilSupport;
    }

    @Override
    public VectorTypeSupport getVectorTypeSupport() {
        return this.vectorTypeSupport;
    }
}

