/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk.feature;

import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.graph.disk.CommonHeader;
import io.github.jbellis.jvector.graph.disk.feature.Feature;
import io.github.jbellis.jvector.graph.disk.feature.FeatureId;
import io.github.jbellis.jvector.graph.disk.feature.InlineVectors;
import io.github.jbellis.jvector.graph.disk.feature.SeparatedFeature;
import io.github.jbellis.jvector.vector.VectorizationProvider;
import io.github.jbellis.jvector.vector.types.VectorTypeSupport;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;

public class SeparatedVectors
implements SeparatedFeature {
    private static final VectorTypeSupport vectorTypeSupport = VectorizationProvider.getInstance().getVectorTypeSupport();
    private final int dimension;
    private long offset;

    public SeparatedVectors(int dimension, long offset) {
        this.dimension = dimension;
        this.offset = offset;
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public FeatureId id() {
        return FeatureId.SEPARATED_VECTORS;
    }

    @Override
    public int headerSize() {
        return 8;
    }

    @Override
    public int featureSize() {
        return this.dimension * 4;
    }

    @Override
    public void writeHeader(DataOutput out) throws IOException {
        out.writeLong(this.offset);
    }

    @Override
    public void writeSeparately(DataOutput out, Feature.State state_) throws IOException {
        InlineVectors.State state = (InlineVectors.State)state_;
        if (state.vector != null) {
            vectorTypeSupport.writeFloatVector(out, state.vector);
        } else {
            for (int j = 0; j < this.dimension; ++j) {
                out.writeFloat(0.0f);
            }
        }
    }

    static SeparatedVectors load(CommonHeader header, RandomAccessReader reader) {
        try {
            long offset = reader.readLong();
            return new SeparatedVectors(header.dimension, offset);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int dimension() {
        return this.dimension;
    }
}

