/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.quantization;

import io.github.jbellis.jvector.quantization.MutableCompressedVectors;
import io.github.jbellis.jvector.quantization.PQVectors;
import io.github.jbellis.jvector.quantization.ProductQuantization;
import io.github.jbellis.jvector.vector.VectorizationProvider;
import io.github.jbellis.jvector.vector.types.ByteSequence;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import io.github.jbellis.jvector.vector.types.VectorTypeSupport;
import java.util.concurrent.atomic.AtomicInteger;

public class MutablePQVectors
extends PQVectors
implements MutableCompressedVectors<VectorFloat<?>> {
    private static final VectorTypeSupport vectorTypeSupport = VectorizationProvider.getInstance().getVectorTypeSupport();
    private static final int VECTORS_PER_CHUNK = 1024;
    private static final int INITIAL_CHUNKS = 10;
    private static final float GROWTH_FACTOR = 1.5f;
    protected AtomicInteger vectorCount = new AtomicInteger(0);

    public MutablePQVectors(ProductQuantization pq) {
        super(pq);
        this.vectorsPerChunk = 1024;
        this.compressedDataChunks = new ByteSequence[10];
    }

    @Override
    public void encodeAndSet(int ordinal, VectorFloat<?> vector) {
        this.ensureChunkCapacity(ordinal);
        this.vectorCount.updateAndGet(current -> Math.max(current, ordinal + 1));
        this.pq.encodeTo(vector, this.get(ordinal));
    }

    @Override
    public void setZero(int ordinal) {
        this.ensureChunkCapacity(ordinal);
        this.vectorCount.updateAndGet(current -> Math.max(current, ordinal + 1));
        this.get(ordinal).zero();
    }

    private void ensureChunkCapacity(int ordinal) {
        int chunkOrdinal = ordinal / this.vectorsPerChunk;
        if (chunkOrdinal >= this.compressedDataChunks.length) {
            int newLength = Math.max(chunkOrdinal + 1, (int)((float)this.compressedDataChunks.length * 1.5f));
            ByteSequence[] newChunks = new ByteSequence[newLength];
            System.arraycopy(this.compressedDataChunks, 0, newChunks, 0, this.compressedDataChunks.length);
            this.compressedDataChunks = newChunks;
        }
        int chunkBytes = 1024 * this.pq.compressedVectorSize();
        for (int i = this.validChunkCount(); i <= chunkOrdinal; ++i) {
            if (this.compressedDataChunks[i] != null) continue;
            this.compressedDataChunks[i] = vectorTypeSupport.createByteSequence(chunkBytes);
        }
    }

    @Override
    protected int validChunkCount() {
        if (this.vectorCount.get() == 0) {
            return 0;
        }
        int chunkOrdinal = (this.vectorCount.get() - 1) / this.vectorsPerChunk;
        return chunkOrdinal + 1;
    }

    @Override
    public int count() {
        return this.vectorCount.get();
    }
}

