/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.pq;

import io.github.jbellis.jvector.annotations.VisibleForTesting;
import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.pq.CompressedVectors;
import io.github.jbellis.jvector.pq.KMeansPlusPlusClusterer;
import io.github.jbellis.jvector.pq.PQVectors;
import io.github.jbellis.jvector.pq.VectorCompressor;
import io.github.jbellis.jvector.util.MathUtil;
import io.github.jbellis.jvector.util.PhysicalCoreExecutor;
import io.github.jbellis.jvector.vector.VectorUtil;
import io.github.jbellis.jvector.vector.VectorizationProvider;
import io.github.jbellis.jvector.vector.types.ByteSequence;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import io.github.jbellis.jvector.vector.types.VectorTypeSupport;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class ProductQuantization
implements VectorCompressor<ByteSequence<?>> {
    private static final int MAGIC = 1978417170;
    private static final VectorTypeSupport vectorTypeSupport = VectorizationProvider.getInstance().getVectorTypeSupport();
    static final int DEFAULT_CLUSTERS = 256;
    static final int K_MEANS_ITERATIONS = 6;
    public static final int MAX_PQ_TRAINING_SET_SIZE = 128000;
    final VectorFloat<?>[] codebooks;
    final int M;
    private final int clusterCount;
    final int originalDimension;
    final VectorFloat<?> globalCentroid;
    final int[][] subvectorSizesAndOffsets;
    final float anisotropicThreshold;
    private final float[][] centroidNormsSquared;
    private final ThreadLocal<VectorFloat<?>> partialSums;
    private final AtomicReference<VectorFloat<?>> partialMagnitudes;
    private final ThreadLocal<VectorFloat<?>> partialBestDistances;
    private final ThreadLocal<ByteSequence<?>> partialQuantizedSums;

    public static ProductQuantization compute(RandomAccessVectorValues ravv, int M, int clusterCount, boolean globallyCenter) {
        return ProductQuantization.compute(ravv, M, clusterCount, globallyCenter, -1.0f, PhysicalCoreExecutor.pool(), ForkJoinPool.commonPool());
    }

    public static ProductQuantization compute(RandomAccessVectorValues ravv, int M, int clusterCount, boolean globallyCenter, float anisotropicThreshold) {
        return ProductQuantization.compute(ravv, M, clusterCount, globallyCenter, anisotropicThreshold, PhysicalCoreExecutor.pool(), ForkJoinPool.commonPool());
    }

    public static ProductQuantization compute(RandomAccessVectorValues ravv, int M, int clusterCount, boolean globallyCenter, float anisotropicThreshold, ForkJoinPool simdExecutor, ForkJoinPool parallelExecutor) {
        VectorFloat<?> globalCentroid;
        int[][] subvectorSizesAndOffsets = ProductQuantization.getSubvectorSizesAndOffsets(ravv.dimension(), M);
        List vectors = ProductQuantization.extractTrainingVectors(ravv, parallelExecutor);
        if (globallyCenter) {
            globalCentroid = KMeansPlusPlusClusterer.centroidOf(vectors);
            List finalVectors = vectors;
            vectors = (List)((ForkJoinTask)simdExecutor.submit(() -> ((Stream)finalVectors.stream().parallel()).map(v -> VectorUtil.sub(v, globalCentroid)).collect(Collectors.toList()))).join();
        } else {
            globalCentroid = null;
        }
        VectorFloat<?>[] codebooks = ProductQuantization.createCodebooks(vectors, subvectorSizesAndOffsets, clusterCount, anisotropicThreshold, simdExecutor);
        return new ProductQuantization(codebooks, clusterCount, subvectorSizesAndOffsets, globalCentroid, anisotropicThreshold);
    }

    static List<VectorFloat<?>> extractTrainingVectors(RandomAccessVectorValues ravv, ForkJoinPool parallelExecutor) {
        float P = Math.min(1.0f, 128000.0f / (float)ravv.size());
        Supplier<RandomAccessVectorValues> ravvCopy = ravv.threadLocalSupplier();
        return (List)((ForkJoinTask)parallelExecutor.submit(() -> IntStream.range(0, ravv.size()).parallel().filter(i -> ThreadLocalRandom.current().nextFloat() < P).mapToObj(arg_0 -> ProductQuantization.lambda$extractTrainingVectors$3((Supplier)ravvCopy, arg_0)).collect(Collectors.toList()))).join();
    }

    public ProductQuantization refine(RandomAccessVectorValues ravv) {
        return this.refine(ravv, 1, -1.0f, PhysicalCoreExecutor.pool(), ForkJoinPool.commonPool());
    }

    public ProductQuantization refine(RandomAccessVectorValues ravv, int lloydsRounds, float anisotropicThreshold, ForkJoinPool simdExecutor, ForkJoinPool parallelExecutor) {
        List vectors;
        if (lloydsRounds < 0) {
            throw new IllegalArgumentException("lloydsRounds must be non-negative");
        }
        int[][] subvectorSizesAndOffsets = ProductQuantization.getSubvectorSizesAndOffsets(ravv.dimension(), this.M);
        List vectorsMutable = ProductQuantization.extractTrainingVectors(ravv, parallelExecutor);
        if (this.globalCentroid != null) {
            vectors = vectorsMutable;
            vectorsMutable = (List)((ForkJoinTask)simdExecutor.submit(() -> ((Stream)vectors.stream().parallel()).map(v -> VectorUtil.sub(v, this.globalCentroid)).collect(Collectors.toList()))).join();
        }
        vectors = vectorsMutable;
        VectorFloat[] refinedCodebooks = (VectorFloat[])((ForkJoinTask)simdExecutor.submit(() -> (VectorFloat[])IntStream.range(0, this.M).parallel().mapToObj(m -> {
            VectorFloat<?>[] subvectors = ProductQuantization.extractSubvectors(vectors, m, subvectorSizesAndOffsets);
            KMeansPlusPlusClusterer clusterer = new KMeansPlusPlusClusterer(subvectors, this.codebooks[m], anisotropicThreshold);
            return clusterer.cluster(anisotropicThreshold == -1.0f ? lloydsRounds : 0, anisotropicThreshold == -1.0f ? 0 : lloydsRounds);
        }).toArray(VectorFloat[]::new))).join();
        return new ProductQuantization(refinedCodebooks, this.clusterCount, subvectorSizesAndOffsets, this.globalCentroid, anisotropicThreshold);
    }

    ProductQuantization(VectorFloat<?>[] codebooks, int clusterCount, int[][] subvectorSizesAndOffsets, VectorFloat<?> globalCentroid, float anisotropicThreshold) {
        this.codebooks = codebooks;
        this.globalCentroid = globalCentroid;
        this.M = codebooks.length;
        this.clusterCount = clusterCount;
        this.subvectorSizesAndOffsets = subvectorSizesAndOffsets;
        this.originalDimension = Arrays.stream(subvectorSizesAndOffsets).mapToInt(m -> m[0]).sum();
        if (globalCentroid != null && globalCentroid.length() != this.originalDimension) {
            String msg = String.format("Global centroid length %d does not match vector dimensionality %d", globalCentroid.length(), this.originalDimension);
            throw new IllegalArgumentException(msg);
        }
        this.anisotropicThreshold = anisotropicThreshold;
        this.partialSums = ThreadLocal.withInitial(() -> vectorTypeSupport.createFloatVector(this.getSubspaceCount() * this.getClusterCount()));
        this.partialQuantizedSums = ThreadLocal.withInitial(() -> vectorTypeSupport.createByteSequence(this.getSubspaceCount() * this.getClusterCount() * 2));
        this.partialMagnitudes = new AtomicReference<Object>(null);
        this.partialBestDistances = ThreadLocal.withInitial(() -> vectorTypeSupport.createFloatVector(this.getSubspaceCount()));
        this.centroidNormsSquared = new float[this.M][clusterCount];
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < clusterCount; ++j) {
                this.centroidNormsSquared[i][j] = VectorUtil.dotProduct(codebooks[i], j * subvectorSizesAndOffsets[i][0], codebooks[i], j * subvectorSizesAndOffsets[i][0], subvectorSizesAndOffsets[i][0]);
            }
        }
    }

    @Override
    public CompressedVectors createCompressedVectors(Object[] compressedVectors) {
        return new PQVectors(this, (ByteSequence[])compressedVectors);
    }

    public ByteSequence<?>[] encodeAll(RandomAccessVectorValues ravv, ForkJoinPool simdExecutor) {
        return (ByteSequence[])((ForkJoinTask)simdExecutor.submit(() -> (ByteSequence[])IntStream.range(0, ravv.size()).parallel().mapToObj(i -> this.encode((VectorFloat)ravv.getVector(i))).toArray(ByteSequence[]::new))).join();
    }

    private ByteSequence<?> encodeAnisotropic(VectorFloat<?> vector) {
        Residual[][] residuals = this.computeResiduals(vector);
        ByteSequence<?> result = this.initializeToMinResidualNorms(residuals);
        float parallelResidualComponentSum = 0.0f;
        for (int i = 0; i < result.length(); ++i) {
            int centroidIdx = Byte.toUnsignedInt(result.get(i));
            parallelResidualComponentSum += residuals[i][centroidIdx].parallelResidualComponent;
        }
        int MAX_ITERATIONS = 10;
        for (int iter = 0; iter < MAX_ITERATIONS; ++iter) {
            boolean changed = false;
            for (int i = 0; i < residuals.length; ++i) {
                int oldIdx = Byte.toUnsignedInt(result.get(i));
                CoordinateDescentResult cdr = this.optimizeSingleSubspace(residuals[i], oldIdx, parallelResidualComponentSum);
                if (cdr.newCenterIdx == oldIdx) continue;
                parallelResidualComponentSum = cdr.newParallelResidualComponent;
                result.set(i, (byte)cdr.newCenterIdx);
                changed = true;
            }
            if (!changed) break;
        }
        return result;
    }

    private CoordinateDescentResult optimizeSingleSubspace(Residual[] residuals, int oldIdx, float oldParallelResidualSum) {
        float pcm = KMeansPlusPlusClusterer.computeParallelCostMultiplier(this.anisotropicThreshold, this.originalDimension);
        float oldResidualNormSquared = residuals[oldIdx].residualNormSquared;
        float oldParallelComponent = residuals[oldIdx].parallelResidualComponent;
        float bestCostDelta = 0.0f;
        int bestIndex = oldIdx;
        float bestParallelResidualSum = oldParallelResidualSum;
        for (int thisIdx = 0; thisIdx < residuals.length; ++thisIdx) {
            float residualNormDelta;
            float perpendicularNormDelta;
            float costDelta;
            if (thisIdx == oldIdx) continue;
            Residual rs = residuals[thisIdx];
            float thisParallelResidualSum = oldParallelResidualSum - oldParallelComponent + rs.parallelResidualComponent;
            float parallelNormDelta = MathUtil.square(thisParallelResidualSum) - MathUtil.square(oldParallelResidualSum);
            if (parallelNormDelta > 0.0f || !((costDelta = pcm * parallelNormDelta + (perpendicularNormDelta = (residualNormDelta = rs.residualNormSquared - oldResidualNormSquared) - parallelNormDelta)) < bestCostDelta)) continue;
            bestCostDelta = costDelta;
            bestIndex = thisIdx;
            bestParallelResidualSum = thisParallelResidualSum;
        }
        return new CoordinateDescentResult(bestIndex, bestParallelResidualSum);
    }

    private ByteSequence<?> initializeToMinResidualNorms(Residual[][] residualStats) {
        ByteSequence<?> result = vectorTypeSupport.createByteSequence(residualStats.length);
        for (int i = 0; i < residualStats.length; ++i) {
            int minIndex = -1;
            double minNormSquared = Double.MAX_VALUE;
            for (int j = 0; j < residualStats[i].length; ++j) {
                if (!((double)residualStats[i][j].residualNormSquared < minNormSquared)) continue;
                minNormSquared = residualStats[i][j].residualNormSquared;
                minIndex = j;
            }
            result.set(i, (byte)minIndex);
        }
        return result;
    }

    private Residual[][] computeResiduals(VectorFloat<?> vector) {
        Residual[][] residuals = new Residual[this.codebooks.length][];
        float inverseNorm = (float)(1.0 / Math.sqrt(VectorUtil.dotProduct(vector, vector)));
        for (int i = 0; i < this.codebooks.length; ++i) {
            VectorFloat<?> x = ProductQuantization.getSubVector(vector, i, this.subvectorSizesAndOffsets);
            float xNormSquared = VectorUtil.dotProduct(x, x);
            residuals[i] = new Residual[this.clusterCount];
            for (int j = 0; j < this.clusterCount; ++j) {
                residuals[i][j] = this.computeResidual(x, this.codebooks[i], j, this.centroidNormsSquared[i][j], xNormSquared, inverseNorm);
            }
        }
        return residuals;
    }

    private Residual computeResidual(VectorFloat<?> x, VectorFloat<?> centroids, int centroid, float cNormSquared, float xNormSquared, float inverseNorm) {
        float cDotX = VectorUtil.dotProduct(centroids, centroid * x.length(), x, 0, x.length());
        float residualNormSquared = cNormSquared - 2.0f * cDotX + xNormSquared;
        float parallelErrorSubtotal = cDotX - xNormSquared;
        float parallelResidualComponent = MathUtil.square(parallelErrorSubtotal) * inverseNorm;
        return new Residual(residualNormSquared, parallelResidualComponent);
    }

    private ByteSequence<?> encodeUnweighted(VectorFloat<?> vector) {
        ByteSequence<?> encoded = vectorTypeSupport.createByteSequence(this.M);
        for (int m = 0; m < this.M; ++m) {
            encoded.set(m, (byte)this.closestCentroidIndex(vector, m, this.codebooks[m]));
        }
        return encoded;
    }

    @Override
    public ByteSequence<?> encode(VectorFloat<?> vector) {
        if (this.globalCentroid != null) {
            vector = VectorUtil.sub(vector, this.globalCentroid);
        }
        return this.anisotropicThreshold > -1.0f ? this.encodeAnisotropic(vector) : this.encodeUnweighted(vector);
    }

    public void decode(ByteSequence<?> encoded, VectorFloat<?> target) {
        this.decodeCentered(encoded, target);
        if (this.globalCentroid != null) {
            VectorUtil.addInPlace(target, this.globalCentroid);
        }
    }

    void decodeCentered(ByteSequence<?> encoded, VectorFloat<?> target) {
        for (int m = 0; m < this.M; ++m) {
            int centroidIndex = Byte.toUnsignedInt(encoded.get(m));
            target.copyFrom(this.codebooks[m], centroidIndex * this.subvectorSizesAndOffsets[m][0], this.subvectorSizesAndOffsets[m][1], this.subvectorSizesAndOffsets[m][0]);
        }
    }

    public int getSubspaceCount() {
        return this.M;
    }

    public int getClusterCount() {
        return this.clusterCount;
    }

    static VectorFloat<?>[] createCodebooks(List<VectorFloat<?>> vectors, int[][] subvectorSizeAndOffset, int clusters, float anisotropicThreshold, ForkJoinPool simdExecutor) {
        int M = subvectorSizeAndOffset.length;
        return (VectorFloat[])((ForkJoinTask)simdExecutor.submit(() -> (VectorFloat[])IntStream.range(0, M).parallel().mapToObj(m -> {
            VectorFloat<?>[] subvectors = ProductQuantization.extractSubvectors(vectors, m, subvectorSizeAndOffset);
            KMeansPlusPlusClusterer clusterer = new KMeansPlusPlusClusterer(subvectors, clusters, anisotropicThreshold);
            return clusterer.cluster(6, anisotropicThreshold == -1.0f ? 0 : 6);
        }).toArray(VectorFloat[]::new))).join();
    }

    private static VectorFloat<?>[] extractSubvectors(List<VectorFloat<?>> vectors, int m, int[][] subvectorSizeAndOffset) {
        return (VectorFloat[])vectors.stream().map(vector -> ProductQuantization.getSubVector(vector, m, subvectorSizeAndOffset)).toArray(VectorFloat[]::new);
    }

    int closestCentroidIndex(VectorFloat<?> subvector, int m, VectorFloat<?> codebook) {
        int index = 0;
        float minDist = Float.MAX_VALUE;
        int subvectorSize = this.subvectorSizesAndOffsets[m][0];
        int subvectorOffset = this.subvectorSizesAndOffsets[m][1];
        for (int i = 0; i < this.clusterCount; ++i) {
            float dist = VectorUtil.squareL2Distance(subvector, subvectorOffset, codebook, i * subvectorSize, subvectorSize);
            if (!(dist < minDist)) continue;
            minDist = dist;
            index = i;
        }
        return index;
    }

    static VectorFloat<?> getSubVector(VectorFloat<?> vector, int m, int[][] subvectorSizeAndOffset) {
        VectorFloat<?> subvector = vectorTypeSupport.createFloatVector(subvectorSizeAndOffset[m][0]);
        subvector.copyFrom(vector, subvectorSizeAndOffset[m][1], 0, subvectorSizeAndOffset[m][0]);
        return subvector;
    }

    @VisibleForTesting
    static int[][] getSubvectorSizesAndOffsets(int dimensions, int M) {
        int[][] sizes = new int[M][];
        int baseSize = dimensions / M;
        int remainder = dimensions % M;
        int offset = 0;
        for (int i = 0; i < M; ++i) {
            int size = baseSize + (i < remainder ? 1 : 0);
            sizes[i] = new int[]{size, offset};
            offset += size;
        }
        return sizes;
    }

    VectorFloat<?> reusablePartialSums() {
        return this.partialSums.get();
    }

    ByteSequence<?> reusablePartialQuantizedSums() {
        return this.partialQuantizedSums.get();
    }

    VectorFloat<?> reusablePartialBestDistances() {
        return this.partialBestDistances.get();
    }

    AtomicReference<VectorFloat<?>> partialMagnitudes() {
        return this.partialMagnitudes;
    }

    @Override
    public void write(DataOutput out, int version) throws IOException {
        if (version > 3) {
            throw new IllegalArgumentException("Unsupported serialization version " + version);
        }
        if (version < 3 && this.anisotropicThreshold != -1.0f) {
            throw new IllegalArgumentException("Anisotropic threshold is only supported in serialization version 3 and above");
        }
        if (version >= 3) {
            out.writeInt(1978417170);
            out.writeInt(version);
        }
        if (this.globalCentroid == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.globalCentroid.length());
            vectorTypeSupport.writeFloatVector(out, this.globalCentroid);
        }
        out.writeInt(this.M);
        assert (Arrays.stream(this.subvectorSizesAndOffsets).mapToInt(m -> m[0]).sum() == this.originalDimension);
        assert (this.M == this.subvectorSizesAndOffsets.length);
        for (int[] a : this.subvectorSizesAndOffsets) {
            out.writeInt(a[0]);
        }
        if (version >= 3) {
            out.writeFloat(this.anisotropicThreshold);
        }
        assert (this.codebooks.length == this.M);
        out.writeInt(this.clusterCount);
        for (int i = 0; i < this.M; ++i) {
            VectorFloat<?> codebook = this.codebooks[i];
            assert (codebook.length() == this.clusterCount * this.subvectorSizesAndOffsets[i][0]);
            vectorTypeSupport.writeFloatVector(out, codebook);
        }
    }

    @Override
    public int compressorSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        if (this.globalCentroid != null) {
            size += 4 * this.globalCentroid.length();
        }
        size += 4;
        size += 4 * this.M;
        size += 4;
        size += 4;
        for (int i = 0; i < this.M; ++i) {
            size += 4 * this.codebooks[i].length();
        }
        return size;
    }

    public static ProductQuantization load(RandomAccessReader in) throws IOException {
        int globalCentroidLength;
        int version;
        int maybeMagic = in.readInt();
        if (maybeMagic != 1978417170) {
            version = 0;
            globalCentroidLength = maybeMagic;
        } else {
            version = in.readInt();
            globalCentroidLength = in.readInt();
        }
        VectorFloat<?> globalCentroid = null;
        if (globalCentroidLength > 0) {
            globalCentroid = vectorTypeSupport.readFloatVector(in, globalCentroidLength);
        }
        int M = in.readInt();
        int[][] subvectorSizes = new int[M][];
        int offset = 0;
        for (int i = 0; i < M; ++i) {
            int size;
            subvectorSizes[i] = new int[2];
            subvectorSizes[i][0] = size = in.readInt();
            subvectorSizes[i][1] = offset;
            offset += size;
        }
        float anisotropicThreshold = version < 3 ? -1.0f : in.readFloat();
        int clusters = in.readInt();
        VectorFloat[] codebooks = new VectorFloat[M];
        for (int m = 0; m < M; ++m) {
            VectorFloat<?> codebook;
            codebooks[m] = codebook = vectorTypeSupport.readFloatVector(in, clusters * subvectorSizes[m][0]);
        }
        return new ProductQuantization(codebooks, clusters, subvectorSizes, globalCentroid, anisotropicThreshold);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductQuantization that = (ProductQuantization)o;
        return this.M == that.M && this.originalDimension == that.originalDimension && Objects.equals(this.globalCentroid, that.globalCentroid) && Arrays.deepEquals((Object[])this.subvectorSizesAndOffsets, (Object[])that.subvectorSizesAndOffsets) && Arrays.deepEquals(this.codebooks, that.codebooks) && this.anisotropicThreshold == that.anisotropicThreshold;
    }

    public int hashCode() {
        int result = Objects.hash(this.M, this.originalDimension);
        result = 31 * result + Arrays.deepHashCode(this.codebooks);
        result = 31 * result + Objects.hashCode(this.globalCentroid);
        result = 31 * result + Arrays.deepHashCode((Object[])this.subvectorSizesAndOffsets);
        return result;
    }

    public VectorFloat<?> getOrComputeCentroid() {
        if (this.globalCentroid != null) {
            return this.globalCentroid;
        }
        VectorFloat<?> centroid = vectorTypeSupport.createFloatVector(this.originalDimension);
        for (int m = 0; m < this.M; ++m) {
            for (int i = 0; i < this.clusterCount; ++i) {
                int subspaceSize = this.subvectorSizesAndOffsets[m][0];
                VectorFloat<?> subCentroid = vectorTypeSupport.createFloatVector(subspaceSize);
                subCentroid.copyFrom(this.codebooks[m], i * subspaceSize, 0, subspaceSize);
                for (int j = 0; j < subspaceSize; ++j) {
                    int k = this.subvectorSizesAndOffsets[m][1] + j;
                    centroid.set(k, centroid.get(k) + subCentroid.get(j));
                }
            }
        }
        VectorUtil.scale(centroid, 1.0f / (float)this.M);
        return centroid;
    }

    @Override
    public int compressedVectorSize() {
        return this.codebooks.length;
    }

    public long memorySize() {
        long size = 0L;
        for (VectorFloat<?> codebook : this.codebooks) {
            size += codebook.ramBytesUsed();
        }
        return size;
    }

    public String toString() {
        if (this.anisotropicThreshold == -1.0f) {
            return String.format("ProductQuantization(M=%d, clusters=%d)", this.M, this.clusterCount);
        }
        return String.format("ProductQuantization(M=%d, clusters=%d, T=%.3f, eta=%.1f)", this.M, this.clusterCount, Float.valueOf(this.anisotropicThreshold), Float.valueOf(KMeansPlusPlusClusterer.computeParallelCostMultiplier(this.anisotropicThreshold, this.originalDimension)));
    }

    private static /* synthetic */ VectorFloat lambda$extractTrainingVectors$3(Supplier ravvCopy, int targetOrd) {
        RandomAccessVectorValues localRavv = (RandomAccessVectorValues)ravvCopy.get();
        VectorFloat<?> v = localRavv.getVector(targetOrd);
        return localRavv.isValueShared() ? v.copy() : v;
    }

    private static class Residual {
        final float residualNormSquared;
        final float parallelResidualComponent;

        Residual(float residualNormSquared, float parallelResidualComponent) {
            this.residualNormSquared = residualNormSquared;
            this.parallelResidualComponent = parallelResidualComponent;
        }
    }

    private static class CoordinateDescentResult {
        final int newCenterIdx;
        final float newParallelResidualComponent;

        CoordinateDescentResult(int newCenterIdx, float newParallelResidualComponent) {
            this.newCenterIdx = newCenterIdx;
            this.newParallelResidualComponent = newParallelResidualComponent;
        }
    }
}

