/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.similarity;

import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.graph.similarity.SearchScoreProvider;
import io.github.jbellis.jvector.pq.PQVectors;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.VectorUtil;
import io.github.jbellis.jvector.vector.VectorizationProvider;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import io.github.jbellis.jvector.vector.types.VectorTypeSupport;
import java.util.function.Supplier;
import org.agrona.collections.Int2ObjectHashMap;

public interface BuildScoreProvider {
    public static final VectorTypeSupport vectorTypeSupport = VectorizationProvider.getInstance().getVectorTypeSupport();

    public boolean isExact();

    public VectorFloat<?> approximateCentroid();

    public SearchScoreProvider searchProviderFor(VectorFloat<?> var1);

    public SearchScoreProvider searchProviderFor(int var1);

    public SearchScoreProvider.Factory diversityProvider();

    public static BuildScoreProvider randomAccessScoreProvider(RandomAccessVectorValues ravv, final VectorSimilarityFunction similarityFunction) {
        final Supplier<RandomAccessVectorValues> vectors = ravv.threadLocalSupplier();
        final Supplier<RandomAccessVectorValues> vectorsCopy = ravv.threadLocalSupplier();
        return new BuildScoreProvider(){

            @Override
            public boolean isExact() {
                return true;
            }

            @Override
            public VectorFloat<?> approximateCentroid() {
                RandomAccessVectorValues vv = (RandomAccessVectorValues)vectors.get();
                VectorFloat<?> centroid = vectorTypeSupport.createFloatVector(vv.dimension());
                for (int i = 0; i < vv.size(); ++i) {
                    VectorFloat<?> v = vv.getVector(i);
                    if (v == null) continue;
                    VectorUtil.addInPlace(centroid, v);
                }
                VectorUtil.scale(centroid, 1.0f / (float)vv.size());
                return centroid;
            }

            @Override
            public SearchScoreProvider searchProviderFor(VectorFloat<?> vector) {
                RandomAccessVectorValues vc = (RandomAccessVectorValues)vectorsCopy.get();
                return SearchScoreProvider.exact(vector, similarityFunction, vc);
            }

            @Override
            public SearchScoreProvider searchProviderFor(int node1) {
                RandomAccessVectorValues randomAccessVectorValues = (RandomAccessVectorValues)vectors.get();
                VectorFloat<?> v = randomAccessVectorValues.getVector(node1);
                return this.searchProviderFor(v);
            }

            @Override
            public SearchScoreProvider.Factory diversityProvider() {
                return arg_0 -> 1.lambda$diversityProvider$0((Supplier)vectors, (Supplier)vectorsCopy, similarityFunction, arg_0);
            }

            private static /* synthetic */ SearchScoreProvider lambda$diversityProvider$0(Supplier vectors2, Supplier vectorsCopy2, VectorSimilarityFunction similarityFunction2, int node1) {
                RandomAccessVectorValues randomAccessVectorValues = (RandomAccessVectorValues)vectors2.get();
                VectorFloat<?> v = randomAccessVectorValues.getVector(node1);
                RandomAccessVectorValues vc = (RandomAccessVectorValues)vectorsCopy2.get();
                return SearchScoreProvider.exact(v, similarityFunction2, vc);
            }
        };
    }

    public static BuildScoreProvider pqBuildScoreProvider(final VectorSimilarityFunction vsf, final RandomAccessVectorValues vp, final PQVectors cv) {
        final int dimension = cv.getOriginalSize() / 4;
        return new BuildScoreProvider(){

            @Override
            public boolean isExact() {
                return false;
            }

            @Override
            public SearchScoreProvider.Factory diversityProvider() {
                final Int2ObjectHashMap cache = new Int2ObjectHashMap();
                return node1 -> {
                    VectorFloat v1 = (VectorFloat)cache.computeIfAbsent(node1, vp::getVector);
                    ScoreFunction.ApproximateScoreFunction asf = cv.scoreFunctionFor(v1, vsf);
                    RandomAccessVectorValues cachedVectors = new RandomAccessVectorValues(){
                        final /* synthetic */ 2 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public int size() {
                            return cv.count();
                        }

                        @Override
                        public int dimension() {
                            return dimension;
                        }

                        @Override
                        public boolean isValueShared() {
                            return false;
                        }

                        @Override
                        public RandomAccessVectorValues copy() {
                            return this;
                        }

                        @Override
                        public void getVectorInto(int node2, VectorFloat<?> result, int offset) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public VectorFloat<?> getVector(int nodeId) {
                            return (VectorFloat)cache.computeIfAbsent(nodeId, vp::getVector);
                        }
                    };
                    ScoreFunction.Reranker rr = ScoreFunction.Reranker.from(v1, vsf, cachedVectors);
                    return new SearchScoreProvider(asf, rr);
                };
            }

            @Override
            public SearchScoreProvider searchProviderFor(int node) {
                return this.searchProviderFor(vp.getVector(node));
            }

            @Override
            public SearchScoreProvider searchProviderFor(VectorFloat<?> vector) {
                return new SearchScoreProvider(cv.precomputedScoreFunctionFor(vector, vsf), null);
            }

            @Override
            public VectorFloat<?> approximateCentroid() {
                return cv.getCompressor().getOrComputeCentroid();
            }
        };
    }
}

