/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import java.util.Map;

public interface OrdinalMapper {
    public int oldToNew(int var1);

    public int newToOld(int var1);

    public static class MapMapper
    implements OrdinalMapper {
        private final Map<Integer, Integer> oldToNew;
        private final int[] newToOld;

        public MapMapper(Map<Integer, Integer> oldToNew) {
            this.oldToNew = oldToNew;
            this.newToOld = new int[oldToNew.size()];
            oldToNew.forEach((old, newOrdinal) -> {
                this.newToOld[newOrdinal.intValue()] = old;
            });
        }

        @Override
        public int oldToNew(int oldOrdinal) {
            return this.oldToNew.get(oldOrdinal);
        }

        @Override
        public int newToOld(int newOrdinal) {
            return this.newToOld[newOrdinal];
        }
    }

    public static class IdentityMapper
    implements OrdinalMapper {
        @Override
        public int oldToNew(int oldOrdinal) {
            return oldOrdinal;
        }

        @Override
        public int newToOld(int newOrdinal) {
            return newOrdinal;
        }
    }
}

