/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.disk.BufferedRandomAccessWriter;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.OnHeapGraphIndex;
import io.github.jbellis.jvector.graph.disk.CommonHeader;
import io.github.jbellis.jvector.graph.disk.Feature;
import io.github.jbellis.jvector.graph.disk.FeatureId;
import io.github.jbellis.jvector.graph.disk.Header;
import io.github.jbellis.jvector.graph.disk.InlineVectors;
import io.github.jbellis.jvector.graph.disk.LVQ;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.IntFunction;
import org.agrona.collections.Int2IntHashMap;

public class OnDiskGraphIndexWriter
implements AutoCloseable {
    private final GraphIndex graph;
    private final GraphIndex.View view;
    private final Map<Integer, Integer> oldToNewOrdinals;
    private final int dimension;
    private final EnumMap<FeatureId, Feature> featureMap;

    private OnDiskGraphIndexWriter(GraphIndex graph, Map<Integer, Integer> oldToNewOrdinals, int dimension, EnumMap<FeatureId, Feature> features) {
        this.graph = graph;
        this.view = graph.getView();
        this.oldToNewOrdinals = oldToNewOrdinals;
        this.dimension = dimension;
        this.featureMap = features;
    }

    @Override
    public void close() throws Exception {
        this.view.close();
    }

    public void writeInline(BufferedRandomAccessWriter raf, int ordinal, EnumMap<FeatureId, Feature.State> stateMap) throws IOException {
        Collection<Feature> features = this.featureMap.values();
        int headerBytes = 8 + CommonHeader.size() + features.stream().mapToInt(Feature::headerSize).sum();
        int edgeSize = 4 * (1 + this.graph.maxDegree());
        int inlineBytes = ordinal * (4 + features.stream().mapToInt(Feature::inlineSize).sum() + edgeSize);
        raf.seek(headerBytes + inlineBytes + 4);
        for (Feature writer : features) {
            Feature.State state = stateMap.get((Object)writer.id());
            if (state == null) {
                raf.seek(raf.getFilePointer() + (long)writer.inlineSize());
                continue;
            }
            raf.writeBuffered(out -> writer.writeInline(out, state));
        }
    }

    public void write(BufferedRandomAccessWriter raf, EnumMap<FeatureId, IntFunction<Feature.State>> featureStateSuppliers) throws IOException {
        OnHeapGraphIndex ohgi;
        if (this.graph instanceof OnHeapGraphIndex && (ohgi = (OnHeapGraphIndex)this.graph).getDeletedNodes().cardinality() > 0) {
            throw new IllegalArgumentException("Run builder.cleanup() before writing the graph");
        }
        if (this.oldToNewOrdinals.size() != this.graph.size()) {
            throw new IllegalArgumentException(String.format("ordinalMapper size %d does not match graph size %d", this.oldToNewOrdinals.size(), this.graph.size()));
        }
        ArrayList<Map.Entry<Integer, Integer>> entriesByNewOrdinal = new ArrayList<Map.Entry<Integer, Integer>>(this.oldToNewOrdinals.entrySet());
        entriesByNewOrdinal.sort(Comparator.comparingInt(Map.Entry::getValue));
        if (this.graph.size() > 0 && entriesByNewOrdinal.get(entriesByNewOrdinal.size() - 1).getValue() != this.graph.size() - 1) {
            throw new IllegalArgumentException("oldToNewOrdinals produced out-of-range entries");
        }
        CommonHeader commonHeader = new CommonHeader(1, this.graph.size(), this.dimension, this.view.entryNode(), this.graph.maxDegree());
        Header header = new Header(commonHeader, this.featureMap);
        raf.writeBuffered(header::write);
        for (int i = 0; i < this.oldToNewOrdinals.size(); ++i) {
            Map.Entry<Integer, Integer> entry = entriesByNewOrdinal.get(i);
            int originalOrdinal = entry.getKey();
            int newOrdinal = entry.getValue();
            if (!this.graph.containsNode(originalOrdinal)) continue;
            raf.writeInt(newOrdinal);
            for (Feature feature : this.featureMap.values()) {
                IntFunction<Feature.State> supplier = featureStateSuppliers.get((Object)feature.id());
                if (supplier == null) {
                    raf.seek(raf.getFilePointer() + (long)feature.inlineSize());
                    continue;
                }
                raf.writeBuffered(out -> feature.writeInline(out, (Feature.State)supplier.apply(originalOrdinal)));
            }
            NodesIterator neighbors = this.view.getNeighborsIterator(originalOrdinal);
            raf.writeBuffered(out -> {
                int n;
                out.writeInt(neighbors.size());
                for (n = 0; n < neighbors.size(); ++n) {
                    out.writeInt(this.oldToNewOrdinals.get(neighbors.nextInt()));
                }
                assert (!neighbors.hasNext());
                while (n < this.graph.maxDegree()) {
                    out.writeInt(-1);
                    ++n;
                }
            });
        }
    }

    public static Map<Integer, Integer> getSequentialRenumbering(GraphIndex graph) {
        Int2IntHashMap int2IntHashMap;
        block9: {
            GraphIndex.View view = graph.getView();
            try {
                Int2IntHashMap oldToNewMap = new Int2IntHashMap(-1);
                int nextOrdinal = 0;
                for (int i = 0; i < view.getIdUpperBound(); ++i) {
                    if (!graph.containsNode(i)) continue;
                    oldToNewMap.put(i, nextOrdinal++);
                }
                int2IntHashMap = oldToNewMap;
                if (view == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (view != null) {
                        try {
                            view.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            view.close();
        }
        return int2IntHashMap;
    }

    public static class Builder {
        private final GraphIndex graphIndex;
        private final Map<Integer, Integer> oldToNewOrdinals;
        private final EnumMap<FeatureId, Feature> features;

        public Builder(GraphIndex graphIndex) {
            this(graphIndex, OnDiskGraphIndexWriter.getSequentialRenumbering(graphIndex));
        }

        public Builder(GraphIndex graphIndex, Map<Integer, Integer> oldToNewOrdinals) {
            this.graphIndex = graphIndex;
            this.oldToNewOrdinals = oldToNewOrdinals;
            this.features = new EnumMap(FeatureId.class);
        }

        public Builder with(Feature feature) {
            this.features.put(feature.id(), feature);
            return this;
        }

        public OnDiskGraphIndexWriter build() {
            int dimension;
            if (this.features.containsKey((Object)FeatureId.FUSED_ADC) && !this.features.containsKey((Object)FeatureId.LVQ) && !this.features.containsKey((Object)FeatureId.INLINE_VECTORS)) {
                throw new IllegalArgumentException("Fused ADC requires an exact score source.");
            }
            if (this.features.containsKey((Object)FeatureId.INLINE_VECTORS)) {
                dimension = ((InlineVectors)this.features.get((Object)FeatureId.INLINE_VECTORS)).dimension();
            } else if (this.features.containsKey((Object)FeatureId.LVQ)) {
                dimension = ((LVQ)this.features.get((Object)FeatureId.LVQ)).dimension();
            } else {
                throw new IllegalArgumentException("Either LVQ or inline vectors must be provided.");
            }
            return new OnDiskGraphIndexWriter(this.graphIndex, this.oldToNewOrdinals, dimension, this.features);
        }
    }
}

