/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbellis.jvector.graph;

import com.github.jbellis.jvector.graph.NeighborSimilarity;
import com.github.jbellis.jvector.graph.SearchResult;
import com.github.jbellis.jvector.util.LongHeap;
import com.github.jbellis.jvector.util.NumericUtils;

public class NeighborQueue {
    private final LongHeap heap;
    private final Order order;
    private boolean incomplete;

    public NeighborQueue(int initialSize, boolean maxHeap) {
        this.heap = new LongHeap(initialSize);
        this.order = maxHeap ? Order.MAX_HEAP : Order.MIN_HEAP;
    }

    public int size() {
        return this.heap.size();
    }

    public void add(int newNode, float newScore) {
        this.heap.push(this.encode(newNode, newScore));
    }

    public boolean insertWithReplacement(int newNode, float newScore) {
        return this.heap.insertWithReplacement(this.encode(newNode, newScore));
    }

    private long encode(int node, float score) {
        return this.order.apply((long)NumericUtils.floatToSortableInt(score) << 32 | 0xFFFFFFFFL & (long)(~node));
    }

    private float decodeScore(long heapValue) {
        return NumericUtils.sortableIntToFloat((int)(this.order.apply(heapValue) >> 32));
    }

    private int decodeNodeId(long heapValue) {
        return (int)(this.order.apply(heapValue) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public int pop() {
        return this.decodeNodeId(this.heap.pop());
    }

    public int[] nodesCopy() {
        int size = this.size();
        int[] nodes = new int[size];
        for (int i = 0; i < size; ++i) {
            nodes[i] = this.decodeNodeId(this.heap.get(i + 1));
        }
        return nodes;
    }

    public SearchResult.NodeScore[] nodesCopy(NeighborSimilarity.ExactScoreFunction sf) {
        int size = this.size();
        SearchResult.NodeScore[] ns = new SearchResult.NodeScore[size];
        for (int i = 0; i < size; ++i) {
            int node = this.decodeNodeId(this.heap.get(i + 1));
            ns[i] = new SearchResult.NodeScore(node, sf.similarityTo(node));
        }
        return ns;
    }

    public int topNode() {
        return this.decodeNodeId(this.heap.top());
    }

    public float topScore() {
        return this.decodeScore(this.heap.top());
    }

    public void clear() {
        this.heap.clear();
        this.incomplete = false;
    }

    public boolean incomplete() {
        return this.incomplete;
    }

    public void markIncomplete() {
        this.incomplete = true;
    }

    boolean isMinHeap() {
        return this.order == Order.MIN_HEAP;
    }

    public String toString() {
        return "Neighbors[" + this.heap.size() + "]";
    }

    private static enum Order {
        MIN_HEAP{

            @Override
            long apply(long v) {
                return v;
            }
        }
        ,
        MAX_HEAP{

            @Override
            long apply(long v) {
                return -1L - v;
            }
        };


        abstract long apply(long var1);
    }
}

