/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbellis.jvector.graph;

import com.github.jbellis.jvector.graph.GraphIndex;
import com.github.jbellis.jvector.graph.NeighborQueue;
import com.github.jbellis.jvector.graph.NeighborSimilarity;
import com.github.jbellis.jvector.graph.NodesIterator;
import com.github.jbellis.jvector.graph.RandomAccessVectorValues;
import com.github.jbellis.jvector.graph.SearchResult;
import com.github.jbellis.jvector.util.BitSet;
import com.github.jbellis.jvector.util.Bits;
import com.github.jbellis.jvector.util.FixedBitSet;
import com.github.jbellis.jvector.util.GrowableBitSet;
import com.github.jbellis.jvector.util.SparseFixedBitSet;
import com.github.jbellis.jvector.vector.VectorEncoding;
import com.github.jbellis.jvector.vector.VectorSimilarityFunction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class GraphSearcher<T> {
    private final GraphIndex.View<T> view;
    private final NeighborQueue candidates;
    private BitSet visited;

    GraphSearcher(GraphIndex.View<T> view, BitSet visited) {
        this.view = view;
        this.candidates = new NeighborQueue(100, true);
        this.visited = visited;
    }

    public static <T> SearchResult search(T targetVector, int topK, RandomAccessVectorValues<T> vectors, VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction, GraphIndex<T> graph, Bits acceptOrds) {
        GraphSearcher<T> searcher = new Builder<T>(graph.getView()).build();
        NeighborSimilarity.ExactScoreFunction scoreFunction = i -> {
            switch (vectorEncoding) {
                case BYTE: {
                    return similarityFunction.compare((byte[])targetVector, (byte[])vectors.vectorValue(i));
                }
                case FLOAT32: {
                    return similarityFunction.compare((float[])targetVector, (float[])vectors.vectorValue(i));
                }
            }
            throw new RuntimeException("Unsupported vector encoding: " + String.valueOf((Object)vectorEncoding));
        };
        return searcher.search(scoreFunction, null, topK, acceptOrds);
    }

    public SearchResult search(NeighborSimilarity.ScoreFunction scoreFunction, NeighborSimilarity.ReRanker<T> reRanker, int topK, Bits acceptOrds) {
        return this.searchInternal(scoreFunction, reRanker, topK, this.view.entryNode(), acceptOrds);
    }

    SearchResult searchInternal(NeighborSimilarity.ScoreFunction scoreFunction, NeighborSimilarity.ReRanker<T> reRanker, int topK, int ep, Bits acceptOrds) {
        SearchResult.NodeScore[] nodes;
        float topCandidateSimilarity;
        if (!scoreFunction.isExact() && reRanker == null) {
            throw new IllegalArgumentException("Either scoreFunction must be exact, or reRanker must not be null");
        }
        if (ep < 0) {
            return new SearchResult(new SearchResult.NodeScore[0], 0);
        }
        this.prepareScratchState(this.view.size());
        NeighborQueue resultsQueue = new NeighborQueue(topK, false);
        HashMap vectorsEncountered = !scoreFunction.isExact() ? new HashMap() : null;
        int numVisited = 0;
        float score = scoreFunction.similarityTo(ep);
        this.visited.set(ep);
        ++numVisited;
        this.candidates.add(ep, score);
        if (acceptOrds == null || acceptOrds.get(ep)) {
            resultsQueue.add(ep, score);
        }
        float minAcceptedSimilarity = Float.NEGATIVE_INFINITY;
        if (resultsQueue.size() >= topK) {
            minAcceptedSimilarity = resultsQueue.topScore();
        }
        while (this.candidates.size() > 0 && !resultsQueue.incomplete() && !((topCandidateSimilarity = this.candidates.topScore()) < minAcceptedSimilarity)) {
            int topCandidateNode = this.candidates.pop();
            if (!scoreFunction.isExact()) {
                vectorsEncountered.put(topCandidateNode, this.view.getVector(topCandidateNode));
            }
            NodesIterator it = this.view.getNeighborsIterator(topCandidateNode);
            while (it.hasNext()) {
                int friendOrd = it.nextInt();
                if (this.visited.getAndSet(friendOrd)) continue;
                ++numVisited;
                float friendSimilarity = scoreFunction.similarityTo(friendOrd);
                if (!(friendSimilarity >= minAcceptedSimilarity)) continue;
                this.candidates.add(friendOrd, friendSimilarity);
                if (acceptOrds != null && !acceptOrds.get(friendOrd) || !resultsQueue.insertWithReplacement(friendOrd, friendSimilarity) || resultsQueue.size() < topK) continue;
                minAcceptedSimilarity = resultsQueue.topScore();
            }
        }
        assert (resultsQueue.size() <= topK);
        if (scoreFunction.isExact()) {
            nodes = new SearchResult.NodeScore[resultsQueue.size()];
            for (int i2 = nodes.length - 1; i2 >= 0; --i2) {
                float nScore = resultsQueue.topScore();
                int n = resultsQueue.pop();
                nodes[i2] = new SearchResult.NodeScore(n, nScore);
            }
        } else {
            nodes = resultsQueue.nodesCopy(i -> reRanker.similarityTo(i, vectorsEncountered));
            Arrays.sort(nodes, 0, resultsQueue.size(), Comparator.comparingDouble(nodeScore -> nodeScore.score).reversed());
        }
        return new SearchResult(nodes, numVisited);
    }

    private void prepareScratchState(int capacity) {
        this.candidates.clear();
        if (this.visited.length() < capacity) {
            assert (this.visited instanceof FixedBitSet || this.visited instanceof GrowableBitSet) : "Unexpected visited type: " + this.visited.getClass().getName();
            if (this.visited instanceof FixedBitSet) {
                this.visited = FixedBitSet.ensureCapacity((FixedBitSet)this.visited, capacity);
            }
        }
        this.visited.clear();
    }

    public static class Builder<T> {
        private final GraphIndex.View<T> graph;
        private boolean concurrent;

        public Builder(GraphIndex.View<T> graph) {
            this.graph = graph;
        }

        public Builder<T> withConcurrentUpdates() {
            this.concurrent = true;
            return this;
        }

        public GraphSearcher<T> build() {
            BitSet bits = this.concurrent ? new GrowableBitSet(this.graph.size()) : new SparseFixedBitSet(this.graph.size());
            return new GraphSearcher<T>(this.graph, bits);
        }
    }
}

