/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamsesso.jsonlogic.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicEvaluator;
import io.github.jamsesso.jsonlogic.utils.JsonValueExtractor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;

public class ArrayLike
implements List<Object> {
    private final List<Object> delegate;

    public ArrayLike(Object data) {
        if (data instanceof List) {
            this.delegate = ((List)data).stream().map(JsonLogicEvaluator::transform).collect(Collectors.toList());
        } else if (data != null && data.getClass().isArray()) {
            this.delegate = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(data); ++i) {
                this.delegate.add(i, JsonLogicEvaluator.transform(Array.get(data, i)));
            }
        } else if (data instanceof JsonArray) {
            this.delegate = (List)JsonValueExtractor.extract((JsonElement)((JsonArray)data));
        } else if (data instanceof Iterable) {
            this.delegate = new ArrayList<Object>();
            for (Object item : (Iterable)data) {
                this.delegate.add(JsonLogicEvaluator.transform(item));
            }
        } else {
            throw new IllegalArgumentException("ArrayLike only works with lists, iterables, arrays, or JsonArray");
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException("ArrayLike is immutable");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("ArrayLike is immutable");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<?> c) {
        throw new UnsupportedOperationException("ArrayLike is immutable");
    }

    @Override
    public boolean addAll(int index, Collection<?> c) {
        throw new UnsupportedOperationException("ArrayLike is immutable");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("ArrayLike is immutable");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("ArrayLike is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("ArrayLike is immutable");
    }

    @Override
    public Object get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public Object set(int index, Object element) {
        throw new UnsupportedOperationException("ArrayLike is immutable");
    }

    @Override
    public void add(int index, Object element) {
        throw new UnsupportedOperationException("ArrayLike is immutable");
    }

    @Override
    public Object remove(int index) {
        throw new UnsupportedOperationException("ArrayLike is immutable");
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.delegate.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    public String toString() {
        return Arrays.toString(this.delegate.toArray());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Iterable) {
            int i = 0;
            for (Object item : (Iterable)other) {
                if (i >= this.delegate.size()) {
                    return false;
                }
                if (!Objects.equals(item, this.delegate.get(i))) {
                    return false;
                }
                ++i;
            }
            if (i != this.delegate.size()) {
                return false;
            }
            return false;
        }
        return false;
    }

    public static boolean isEligible(Object data) {
        return data != null && (data instanceof Iterable || data.getClass().isArray());
    }
}

