/*
 * Decompiled with CFR 0.152.
 */
package io.github.inflationx.viewpump;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import io.github.inflationx.viewpump.FallbackViewCreator;
import io.github.inflationx.viewpump.InflateRequest;
import io.github.inflationx.viewpump.ReflectionUtils;
import io.github.inflationx.viewpump.ViewPump;
import io.github.inflationx.viewpump.ViewPumpActivityFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.xmlpull.v1.XmlPullParser;

class ViewPumpLayoutInflater
extends LayoutInflater
implements ViewPumpActivityFactory {
    private static final String[] sClassPrefixList = new String[]{"android.widget.", "android.webkit."};
    private FallbackViewCreator nameAndAttrsViewCreator = new NameAndAttrsViewCreator(this);
    private FallbackViewCreator parentAndNameAndAttrsViewCreator = new ParentAndNameAndAttrsViewCreator(this);
    private boolean mSetPrivateFactory = false;
    private Field mConstructorArgs = null;

    protected ViewPumpLayoutInflater(Context context) {
        super(context);
        this.setUpLayoutFactories(false);
    }

    protected ViewPumpLayoutInflater(LayoutInflater original, Context newContext, boolean cloned) {
        super(original, newContext);
        this.setUpLayoutFactories(cloned);
    }

    public LayoutInflater cloneInContext(Context newContext) {
        return new ViewPumpLayoutInflater(this, newContext, true);
    }

    public View inflate(XmlPullParser parser, ViewGroup root, boolean attachToRoot) {
        this.setPrivateFactoryInternal();
        return super.inflate(parser, root, attachToRoot);
    }

    private void setUpLayoutFactories(boolean cloned) {
        if (cloned) {
            return;
        }
        if (this.getFactory2() != null && !(this.getFactory2() instanceof WrapperFactory2)) {
            this.setFactory2(this.getFactory2());
        }
        if (this.getFactory() != null && !(this.getFactory() instanceof WrapperFactory)) {
            this.setFactory(this.getFactory());
        }
    }

    public void setFactory(LayoutInflater.Factory factory) {
        if (!(factory instanceof WrapperFactory)) {
            super.setFactory((LayoutInflater.Factory)new WrapperFactory(factory));
        } else {
            super.setFactory(factory);
        }
    }

    public void setFactory2(LayoutInflater.Factory2 factory2) {
        if (!(factory2 instanceof WrapperFactory2)) {
            super.setFactory2((LayoutInflater.Factory2)new WrapperFactory2(factory2));
        } else {
            super.setFactory2(factory2);
        }
    }

    private void setPrivateFactoryInternal() {
        if (this.mSetPrivateFactory) {
            return;
        }
        if (!ViewPump.get().isReflection()) {
            return;
        }
        if (!(this.getContext() instanceof LayoutInflater.Factory2)) {
            this.mSetPrivateFactory = true;
            return;
        }
        Method setPrivateFactoryMethod = ReflectionUtils.getMethod(LayoutInflater.class, "setPrivateFactory");
        if (setPrivateFactoryMethod != null) {
            ReflectionUtils.invokeMethod(this, setPrivateFactoryMethod, new PrivateWrapperFactory2((LayoutInflater.Factory2)this.getContext(), this));
        }
        this.mSetPrivateFactory = true;
    }

    @Override
    public View onActivityCreateView(View parent, View view, String name, Context context, AttributeSet attrs) {
        return ViewPump.get().inflate(InflateRequest.builder().name(name).context(context).attrs(attrs).parent(parent).fallbackViewCreator(new ActivityViewCreator(this, view)).build()).view();
    }

    protected View onCreateView(View parent, String name, AttributeSet attrs) throws ClassNotFoundException {
        return ViewPump.get().inflate(InflateRequest.builder().name(name).context(this.getContext()).attrs(attrs).parent(parent).fallbackViewCreator(this.parentAndNameAndAttrsViewCreator).build()).view();
    }

    protected View onCreateView(String name, AttributeSet attrs) throws ClassNotFoundException {
        return ViewPump.get().inflate(InflateRequest.builder().name(name).context(this.getContext()).attrs(attrs).fallbackViewCreator(this.nameAndAttrsViewCreator).build()).view();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private View createCustomViewInternal(View parent, View view, String name, Context viewContext, AttributeSet attrs) {
        if (!ViewPump.get().isCustomViewCreation()) {
            return view;
        }
        if (view == null && name.indexOf(46) > -1) {
            if (this.mConstructorArgs == null) {
                this.mConstructorArgs = ReflectionUtils.getField(LayoutInflater.class, "mConstructorArgs");
            }
            Object[] mConstructorArgsArr = (Object[])ReflectionUtils.getValue(this.mConstructorArgs, this);
            Object lastContext = mConstructorArgsArr[0];
            mConstructorArgsArr[0] = viewContext;
            ReflectionUtils.setValue(this.mConstructorArgs, this, mConstructorArgsArr);
            try {
                view = this.createView(name, null, attrs);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            finally {
                mConstructorArgsArr[0] = lastContext;
                ReflectionUtils.setValue(this.mConstructorArgs, this, mConstructorArgsArr);
            }
        }
        return view;
    }

    private View superOnCreateView(View parent, String name, AttributeSet attrs) {
        try {
            return super.onCreateView(parent, name, attrs);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private View superOnCreateView(String name, AttributeSet attrs) {
        try {
            return super.onCreateView(name, attrs);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static class PrivateWrapperFactory2ViewCreator
    extends WrapperFactory2ViewCreator
    implements FallbackViewCreator {
        private final ViewPumpLayoutInflater mInflater;

        public PrivateWrapperFactory2ViewCreator(LayoutInflater.Factory2 factory2, ViewPumpLayoutInflater mInflater) {
            super(factory2);
            this.mInflater = mInflater;
        }

        @Override
        public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
            return this.mInflater.createCustomViewInternal(parent, this.mFactory2.onCreateView(parent, name, context, attrs), name, context, attrs);
        }
    }

    private static class PrivateWrapperFactory2
    extends WrapperFactory2 {
        private final PrivateWrapperFactory2ViewCreator mViewCreator;

        public PrivateWrapperFactory2(LayoutInflater.Factory2 factory2, ViewPumpLayoutInflater inflater) {
            super(factory2);
            this.mViewCreator = new PrivateWrapperFactory2ViewCreator(factory2, inflater);
        }

        @Override
        public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
            return ViewPump.get().inflate(InflateRequest.builder().name(name).context(context).attrs(attrs).parent(parent).fallbackViewCreator(this.mViewCreator).build()).view();
        }
    }

    private static class WrapperFactory2ViewCreator
    implements FallbackViewCreator {
        protected final LayoutInflater.Factory2 mFactory2;

        public WrapperFactory2ViewCreator(LayoutInflater.Factory2 factory2) {
            this.mFactory2 = factory2;
        }

        @Override
        public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
            return this.mFactory2.onCreateView(parent, name, context, attrs);
        }
    }

    private static class WrapperFactory2
    implements LayoutInflater.Factory2 {
        protected final LayoutInflater.Factory2 mFactory2;
        private final WrapperFactory2ViewCreator mViewCreator;

        public WrapperFactory2(LayoutInflater.Factory2 factory2) {
            this.mFactory2 = factory2;
            this.mViewCreator = new WrapperFactory2ViewCreator(factory2);
        }

        public View onCreateView(String name, Context context, AttributeSet attrs) {
            return this.onCreateView(null, name, context, attrs);
        }

        public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
            return ViewPump.get().inflate(InflateRequest.builder().name(name).context(context).attrs(attrs).parent(parent).fallbackViewCreator(this.mViewCreator).build()).view();
        }
    }

    private static class WrapperFactoryViewCreator
    implements FallbackViewCreator {
        protected final LayoutInflater.Factory mFactory;

        public WrapperFactoryViewCreator(LayoutInflater.Factory factory) {
            this.mFactory = factory;
        }

        @Override
        public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
            return this.mFactory.onCreateView(name, context, attrs);
        }
    }

    private static class WrapperFactory
    implements LayoutInflater.Factory {
        private final FallbackViewCreator mViewCreator;

        public WrapperFactory(LayoutInflater.Factory factory) {
            this.mViewCreator = new WrapperFactoryViewCreator(factory);
        }

        public View onCreateView(String name, Context context, AttributeSet attrs) {
            return ViewPump.get().inflate(InflateRequest.builder().name(name).context(context).attrs(attrs).fallbackViewCreator(this.mViewCreator).build()).view();
        }
    }

    private static class NameAndAttrsViewCreator
    implements FallbackViewCreator {
        private final ViewPumpLayoutInflater inflater;

        public NameAndAttrsViewCreator(ViewPumpLayoutInflater inflater) {
            this.inflater = inflater;
        }

        @Override
        public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
            View view = null;
            for (String prefix : sClassPrefixList) {
                try {
                    view = this.inflater.createView(name, prefix, attrs);
                    if (view == null) continue;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (view == null) {
                view = this.inflater.superOnCreateView(name, attrs);
            }
            return view;
        }
    }

    private static class ParentAndNameAndAttrsViewCreator
    implements FallbackViewCreator {
        private final ViewPumpLayoutInflater inflater;

        public ParentAndNameAndAttrsViewCreator(ViewPumpLayoutInflater inflater) {
            this.inflater = inflater;
        }

        @Override
        public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
            return this.inflater.superOnCreateView(parent, name, attrs);
        }
    }

    private static class ActivityViewCreator
    implements FallbackViewCreator {
        private final ViewPumpLayoutInflater inflater;
        private final View view;

        public ActivityViewCreator(ViewPumpLayoutInflater inflater, View view) {
            this.inflater = inflater;
            this.view = view;
        }

        @Override
        public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
            return this.inflater.createCustomViewInternal(parent, this.view, name, context, attrs);
        }
    }
}

