/*
 * Decompiled with CFR 0.152.
 */
package io.github.inflationx.viewpump;

import android.support.annotation.MainThread;
import io.github.inflationx.viewpump.FallbackViewCreationInterceptor;
import io.github.inflationx.viewpump.InflateRequest;
import io.github.inflationx.viewpump.InflateResult;
import io.github.inflationx.viewpump.Interceptor;
import io.github.inflationx.viewpump.InterceptorChain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ViewPump {
    private static ViewPump INSTANCE;
    private final List<Interceptor> interceptors;
    private final List<Interceptor> mInterceptorsWithFallback;
    private final boolean mReflection;
    private final boolean mCustomViewCreation;

    private ViewPump(Builder builder) {
        this.interceptors = ViewPump.immutableList(builder.interceptors);
        List interceptorsWithFallback = builder.interceptors;
        interceptorsWithFallback.add(new FallbackViewCreationInterceptor());
        this.mInterceptorsWithFallback = ViewPump.immutableList(interceptorsWithFallback);
        this.mReflection = builder.reflection;
        this.mCustomViewCreation = builder.customViewCreation;
    }

    public static void init(ViewPump viewPump) {
        INSTANCE = viewPump;
    }

    @MainThread
    public static ViewPump get() {
        if (INSTANCE == null) {
            INSTANCE = ViewPump.builder().build();
        }
        return INSTANCE;
    }

    public InflateResult inflate(InflateRequest originalRequest) {
        InterceptorChain chain = new InterceptorChain(this.mInterceptorsWithFallback, 0, originalRequest);
        return chain.proceed(originalRequest);
    }

    public List<Interceptor> interceptors() {
        return this.interceptors;
    }

    public boolean isReflection() {
        return this.mReflection;
    }

    public boolean isCustomViewCreation() {
        return this.mCustomViewCreation;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> immutableList(List<T> list) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static final class Builder {
        private final List<Interceptor> interceptors = new ArrayList<Interceptor>();
        private boolean reflection = true;
        private boolean customViewCreation = true;

        private Builder() {
        }

        public Builder addInterceptor(Interceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public Builder setPrivateFactoryInjectionEnabled(boolean enabled) {
            this.reflection = enabled;
            return this;
        }

        public Builder setCustomViewInflationEnabled(boolean enabled) {
            this.customViewCreation = enabled;
            return this;
        }

        public ViewPump build() {
            return new ViewPump(this);
        }
    }
}

