/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.keymanager;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import nl.altindag.ssl.keymanager.DelegatingX509ExtendedKeyManager;
import nl.altindag.ssl.util.internal.ValidationUtils;

public final class HotSwappableX509ExtendedKeyManager
extends DelegatingX509ExtendedKeyManager {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    public HotSwappableX509ExtendedKeyManager(X509ExtendedKeyManager keyManager) {
        super(keyManager);
    }

    public void setKeyManager(X509ExtendedKeyManager keyManager) {
        this.writeLock.lock();
        try {
            this.keyManager = ValidationUtils.requireNotNull(keyManager, (String)ValidationUtils.GENERIC_EXCEPTION_MESSAGE.apply("KeyManager"));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        this.readLock.lock();
        try {
            String string = super.chooseClientAlias(keyType, issuers, socket);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        this.readLock.lock();
        try {
            String string = super.chooseServerAlias(keyType, issuers, socket);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        this.readLock.lock();
        try {
            PrivateKey privateKey = super.getPrivateKey(alias);
            return privateKey;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        this.readLock.lock();
        try {
            X509Certificate[] x509CertificateArray = super.getCertificateChain(alias);
            return x509CertificateArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        this.readLock.lock();
        try {
            String[] stringArray = super.getClientAliases(keyType, issuers);
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        this.readLock.lock();
        try {
            String[] stringArray = super.getServerAliases(keyType, issuers);
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public X509ExtendedKeyManager getInnerKeyManager() {
        this.readLock.lock();
        try {
            X509ExtendedKeyManager x509ExtendedKeyManager = (X509ExtendedKeyManager)super.getInnerKeyManager();
            return x509ExtendedKeyManager;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine sslEngine) {
        this.readLock.lock();
        try {
            String string = super.chooseEngineClientAlias(keyTypes, issuers, sslEngine);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine sslEngine) {
        this.readLock.lock();
        try {
            String string = super.chooseEngineServerAlias(keyType, issuers, sslEngine);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

