/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import nl.altindag.ssl.exception.GenericException;
import nl.altindag.ssl.exception.GenericIOException;
import nl.altindag.ssl.util.CertificateUtils;
import nl.altindag.ssl.util.CollectorsUtils;
import nl.altindag.ssl.util.IOUtils;

final class MacCertificateUtils {
    private static final Path HOME_DIRECTORY = Paths.get(System.getProperty("user.home"), new String[0]);
    private static final String SYSTEM_ROOT_KEYCHAIN_FILE = "/System/Library/Keychains/SystemRootCertificates.keychain";
    private static final List<String> KEYCHAIN_LOOKUP_COMMANDS = Arrays.asList("list-keychains", "default-keychain");

    private MacCertificateUtils() {
    }

    public static List<Certificate> getCertificates() {
        if (!System.getProperty("os.name").toLowerCase().contains("mac")) {
            return Collections.emptyList();
        }
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        StringBuilder stringBuilder = new StringBuilder();
        MacCertificateUtils.getKeychainFiles(executorService).stream().distinct().map(MacCertificateUtils::createProcessForGettingCertificates).map(process -> new StringInputStreamRunnable(process.getInputStream(), content -> stringBuilder.append((String)content).append(System.lineSeparator()))).map(executorService::submit).forEach(MacCertificateUtils::waitAtMostTillTimeout);
        executorService.shutdownNow();
        String certificateContent = stringBuilder.toString();
        return CertificateUtils.parsePemCertificate(certificateContent).stream().distinct().collect(CollectorsUtils.toUnmodifiableList());
    }

    private static List<String> getKeychainFiles(ExecutorService executorService) {
        ArrayList<String> keychainFiles = new ArrayList<String>();
        keychainFiles.add(SYSTEM_ROOT_KEYCHAIN_FILE);
        KEYCHAIN_LOOKUP_COMMANDS.stream().map(MacCertificateUtils::createProcessForGettingKeychainFile).map(process -> new StringInputStreamRunnable(process.getInputStream(), content -> Stream.of(content.split(System.lineSeparator())).map(line -> line.replace("\"", "")).map(String::trim).forEach(keychainFiles::add))).map(executorService::submit).forEach(MacCertificateUtils::waitAtMostTillTimeout);
        return keychainFiles;
    }

    private static Process createProcessForGettingKeychainFile(String command) {
        return MacCertificateUtils.createProcess("security " + command);
    }

    private static Process createProcessForGettingCertificates(String keychainFilePath) {
        return MacCertificateUtils.createProcess("security find-certificate -a -p " + keychainFilePath);
    }

    private static Process createProcess(String command) {
        try {
            return MacCertificateUtils.createProcess().command("sh", "-c", command).directory(HOME_DIRECTORY.toFile()).start();
        }
        catch (IOException e) {
            throw new GenericIOException(e);
        }
    }

    static ProcessBuilder createProcess() {
        return new ProcessBuilder(new String[0]);
    }

    static void waitAtMostTillTimeout(Future<?> future) {
        try {
            future.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Thread.currentThread().interrupt();
            throw new GenericException(e);
        }
    }

    private static class StringInputStreamRunnable
    implements Runnable {
        private final InputStream inputStream;
        private final Consumer<String> consumer;

        public StringInputStreamRunnable(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            String content = IOUtils.getContent(this.inputStream);
            this.consumer.accept(content);
        }
    }
}

