/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import nl.altindag.ssl.exception.GenericIOException;

public final class IOUtils {
    private IOUtils() {
    }

    /*
     * Exception decompiling
     */
    static String getContent(InputStream inputStream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] copyToByteArray(InputStream inputStream) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) > -1) {
                outputStream.write(buffer, 0, length);
            }
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new GenericIOException(e);
        }
    }

    static void closeSilently(AutoCloseable autoCloseable) {
        try {
            autoCloseable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static InputStream getResourceAsStream(String name) {
        return IOUtils.class.getClassLoader().getResourceAsStream(name);
    }

    static InputStream getFileAsStream(Path path) {
        try {
            return Files.newInputStream(path, StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw new GenericIOException(e);
        }
    }

    static void write(Path path, byte[] data) {
        try {
            Files.write(path, data, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new GenericIOException(e);
        }
    }

    static void write(Path path, Consumer<OutputStream> consumer) {
        try (OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.CREATE);){
            consumer.accept(outputStream);
        }
        catch (Exception e) {
            throw new GenericIOException(e);
        }
    }

    @FunctionalInterface
    static interface Consumer<T> {
        public void accept(T var1) throws Exception;
    }
}

