/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.model;

import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import nl.altindag.ssl.model.KeyStoreHolder;

public final class IdentityMaterial {
    private X509ExtendedKeyManager keyManager;
    private KeyManagerFactory keyManagerFactory;
    private List<KeyStoreHolder> identities;
    private Map<String, List<String>> preferredClientAliasToHost;

    private IdentityMaterial() {
    }

    public X509ExtendedKeyManager getKeyManager() {
        return this.keyManager;
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    public List<KeyStoreHolder> getIdentities() {
        return this.identities;
    }

    public Map<String, List<String>> getPreferredClientAliasToHost() {
        return this.preferredClientAliasToHost;
    }

    public static class Builder {
        private X509ExtendedKeyManager keyManager;
        private KeyManagerFactory keyManagerFactory;
        private List<KeyStoreHolder> identities;
        private Map<String, List<String>> preferredClientAliasToHost;

        public Builder withKeyManager(X509ExtendedKeyManager keyManager) {
            this.keyManager = keyManager;
            return this;
        }

        public Builder withKeyManagerFactory(KeyManagerFactory keyManagerFactory) {
            this.keyManagerFactory = keyManagerFactory;
            return this;
        }

        public Builder withIdentities(List<KeyStoreHolder> identities) {
            this.identities = identities;
            return this;
        }

        public Builder withPreferredClientAliasToHost(Map<String, List<String>> preferredClientAliasToHost) {
            this.preferredClientAliasToHost = preferredClientAliasToHost;
            return this;
        }

        public IdentityMaterial build() {
            IdentityMaterial identityMaterial = new IdentityMaterial();
            identityMaterial.keyManager = this.keyManager;
            identityMaterial.keyManagerFactory = this.keyManagerFactory;
            identityMaterial.identities = this.identities;
            identityMaterial.preferredClientAliasToHost = this.preferredClientAliasToHost;
            return identityMaterial;
        }
    }
}

