/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.model;

import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import nl.altindag.ssl.model.KeyStoreHolder;

public final class TrustMaterial {
    private X509ExtendedTrustManager trustManager;
    private TrustManagerFactory trustManagerFactory;
    private List<X509Certificate> trustedCertificates;
    private List<KeyStoreHolder> trustStores;

    private TrustMaterial() {
    }

    public X509ExtendedTrustManager getTrustManager() {
        return this.trustManager;
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public List<X509Certificate> getTrustedCertificates() {
        return this.trustedCertificates;
    }

    public List<KeyStoreHolder> getTrustStores() {
        return this.trustStores;
    }

    public static class Builder {
        private X509ExtendedTrustManager trustManager;
        private TrustManagerFactory trustManagerFactory;
        private List<X509Certificate> trustedCertificates;
        private List<KeyStoreHolder> trustStores;

        public Builder withTrustManager(X509ExtendedTrustManager trustManager) {
            this.trustManager = trustManager;
            return this;
        }

        public Builder withTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
            this.trustManagerFactory = trustManagerFactory;
            return this;
        }

        public Builder withTrustedCertificates(List<X509Certificate> trustedCertificates) {
            this.trustedCertificates = trustedCertificates;
            return this;
        }

        public Builder withTrustStores(List<KeyStoreHolder> trustStores) {
            this.trustStores = trustStores;
            return this;
        }

        public TrustMaterial build() {
            TrustMaterial trustMaterial = new TrustMaterial();
            trustMaterial.trustManager = this.trustManager;
            trustMaterial.trustManagerFactory = this.trustManagerFactory;
            trustMaterial.trustedCertificates = this.trustedCertificates;
            trustMaterial.trustStores = this.trustStores;
            return trustMaterial;
        }
    }
}

