/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.sslcontext;

import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import nl.altindag.sslcontext.exception.GenericKeyStoreException;
import nl.altindag.sslcontext.exception.GenericSSLContextException;
import nl.altindag.sslcontext.exception.GenericSecurityException;
import nl.altindag.sslcontext.keymanager.CompositeX509ExtendedKeyManager;
import nl.altindag.sslcontext.model.KeyStoreHolder;
import nl.altindag.sslcontext.trustmanager.CompositeX509ExtendedTrustManager;
import nl.altindag.sslcontext.trustmanager.UnsafeX509ExtendedTrustManager;
import nl.altindag.sslcontext.util.KeyStoreUtils;
import nl.altindag.sslcontext.util.TrustManagerUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SSLFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSLFactory.class);
    private static final char[] EMPTY_PASSWORD = new char[0];
    private final String protocol;
    private final SecureRandom secureRandom;
    private final HostnameVerifier hostnameVerifier;
    private final List<KeyStoreHolder> identities = new ArrayList<KeyStoreHolder>();
    private final List<X509ExtendedKeyManager> identityManagers = new ArrayList<X509ExtendedKeyManager>();
    private final List<KeyStoreHolder> trustStores = new ArrayList<KeyStoreHolder>();
    private final List<X509ExtendedTrustManager> trustManagers = new ArrayList<X509ExtendedTrustManager>();
    private final boolean includeDefaultJdkTrustStore;
    private final boolean trustingAllCertificatesWithoutValidationEnabled;
    private final boolean passwordCachingEnabled;
    private SSLContext sslContext;
    private CompositeX509ExtendedTrustManager trustManager;
    private CompositeX509ExtendedKeyManager keyManager;

    private SSLFactory(String protocol, SecureRandom secureRandom, HostnameVerifier hostnameVerifier, List<KeyStoreHolder> identities, List<X509ExtendedKeyManager> identityManagers, List<KeyStoreHolder> trustStores, List<X509ExtendedTrustManager> trustManagers, boolean includeDefaultJdkTrustStore, boolean trustingAllCertificatesWithoutValidationEnabled, boolean passwordCachingEnabled) {
        this.protocol = protocol;
        this.secureRandom = secureRandom;
        this.hostnameVerifier = hostnameVerifier;
        this.identities.addAll(identities);
        this.identityManagers.addAll(identityManagers);
        this.trustStores.addAll(trustStores);
        this.trustManagers.addAll(trustManagers);
        this.includeDefaultJdkTrustStore = includeDefaultJdkTrustStore;
        this.trustingAllCertificatesWithoutValidationEnabled = trustingAllCertificatesWithoutValidationEnabled;
        this.passwordCachingEnabled = passwordCachingEnabled;
    }

    private void createSSLContextWithTrustMaterial() {
        this.createSSLContext(null, this.createTrustManagers());
    }

    private void createSSLContextWithKeyMaterialAndTrustMaterial() {
        this.createSSLContext(this.createKeyManager(), this.createTrustManagers());
    }

    private void createSSLContext(KeyManager[] keyManagers, TrustManager[] trustManagers) {
        try {
            this.sslContext = SSLContext.getInstance(this.protocol);
            this.sslContext.init(keyManagers, trustManagers, this.secureRandom);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new GenericSSLContextException(e);
        }
    }

    private KeyManager[] createKeyManager() {
        this.keyManager = CompositeX509ExtendedKeyManager.builder().withKeyManagers(this.identityManagers).withIdentities(this.identities).build();
        if (!this.passwordCachingEnabled && !this.identities.isEmpty()) {
            List<KeyStoreHolder> sanitizedIdentities = this.sanitizeKeyStores(this.identities);
            this.identities.clear();
            this.identities.addAll(sanitizedIdentities);
        }
        return new X509ExtendedKeyManager[]{this.keyManager};
    }

    private TrustManager[] createTrustManagers() {
        CompositeX509ExtendedTrustManager.Builder trustManagerBuilder = CompositeX509ExtendedTrustManager.builder().withTrustManagers(this.trustManagers).withTrustStores(this.trustStores.stream().map(KeyStoreHolder::getKeyStore).collect(Collectors.toList()));
        if (this.trustingAllCertificatesWithoutValidationEnabled) {
            LOGGER.warn("UnsafeTrustManager is being used. Client/Server certificates will be accepted without validation. Please don't use this configuration at production.");
            trustManagerBuilder.withTrustManagers(new UnsafeX509ExtendedTrustManager[]{UnsafeX509ExtendedTrustManager.INSTANCE});
        }
        if (this.includeDefaultJdkTrustStore) {
            trustManagerBuilder.withTrustManagers(new X509ExtendedTrustManager[]{TrustManagerUtils.createTrustManagerWithJdkTrustedCertificates()});
        }
        this.trustManager = trustManagerBuilder.build();
        if (!this.passwordCachingEnabled && !this.trustStores.isEmpty()) {
            List<KeyStoreHolder> sanitizedTrustStores = this.sanitizeKeyStores(this.trustStores);
            this.trustStores.clear();
            this.trustStores.addAll(sanitizedTrustStores);
        }
        return new TrustManager[]{this.trustManager};
    }

    private List<KeyStoreHolder> sanitizeKeyStores(List<KeyStoreHolder> keyStores) {
        return keyStores.stream().map(keyStoreHolder -> new KeyStoreHolder(keyStoreHolder.getKeyStore(), EMPTY_PASSWORD, EMPTY_PASSWORD)).collect(Collectors.toList());
    }

    public List<KeyStoreHolder> getIdentities() {
        return Collections.unmodifiableList(this.identities);
    }

    public List<KeyStoreHolder> getTrustStores() {
        return Collections.unmodifiableList(this.trustStores);
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public Optional<X509ExtendedKeyManager> getKeyManager() {
        return Optional.ofNullable(this.keyManager);
    }

    public X509ExtendedTrustManager getTrustManager() {
        return this.trustManager;
    }

    public X509Certificate[] getTrustedCertificates() {
        return this.trustManager.getAcceptedIssuers();
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final String TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE = "TrustStore details are empty, which are required to be present when SSL/TLS is enabled";
        private static final String TRUST_STRATEGY_VALIDATION_EXCEPTION_MESSAGE = "Trust strategy is missing. Please validate if the TrustStore is present, or including default JDK TrustStore is enabled, or TrustManager is present, or trusting all certificates without validation is enabled";
        private static final String IDENTITY_VALIDATION_EXCEPTION_MESSAGE = "Identity details are empty, which are required to be present when SSL/TLS is enabled";
        private static final String KEY_STORE_LOADING_EXCEPTION = "Failed to load the keystore";
        public static final String IDENTITY_AND_TRUST_MATERIAL_VALIDATION_EXCEPTION_MESSAGE = "Could not create instance of SSLFactory because Identity and Trust material are not present. Please provide at least a Trust material.";
        private String protocol = "TLSv1.2";
        private SecureRandom secureRandom = new SecureRandom();
        private HostnameVerifier hostnameVerifier = (host, sslSession) -> host.equalsIgnoreCase(sslSession.getPeerHost());
        private final List<KeyStoreHolder> identities = new ArrayList<KeyStoreHolder>();
        private final List<KeyStoreHolder> trustStores = new ArrayList<KeyStoreHolder>();
        private final List<X509ExtendedKeyManager> identityManagers = new ArrayList<X509ExtendedKeyManager>();
        private final List<X509ExtendedTrustManager> trustManagers = new ArrayList<X509ExtendedTrustManager>();
        private boolean includeDefaultJdkTrustStore = false;
        private boolean trustingAllCertificatesWithoutValidationEnabled = false;
        private boolean passwordCachingEnabled = false;

        private Builder() {
        }

        public Builder withDefaultJdkTrustStore() {
            this.includeDefaultJdkTrustStore = true;
            return this;
        }

        public Builder withTrustManager(X509ExtendedTrustManager trustManager) {
            this.trustManagers.add(trustManager);
            return this;
        }

        public Builder withTrustStore(String trustStorePath, char[] trustStorePassword) {
            return this.withTrustStore(trustStorePath, trustStorePassword, KeyStore.getDefaultType());
        }

        public Builder withTrustStore(String trustStorePath, char[] trustStorePassword, String trustStoreType) {
            if (StringUtils.isBlank((CharSequence)trustStorePath) || ArrayUtils.isEmpty((char[])trustStorePassword)) {
                throw new GenericKeyStoreException(TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE);
            }
            try {
                KeyStore trustStore = KeyStoreUtils.loadKeyStore(trustStorePath, trustStorePassword, trustStoreType);
                KeyStoreHolder trustStoreHolder = new KeyStoreHolder(trustStore, trustStorePassword);
                this.trustStores.add(trustStoreHolder);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException(KEY_STORE_LOADING_EXCEPTION, e);
            }
            return this;
        }

        public Builder withTrustStore(Path trustStorePath, char[] trustStorePassword) {
            return this.withTrustStore(trustStorePath, trustStorePassword, KeyStore.getDefaultType());
        }

        public Builder withTrustStore(Path trustStorePath, char[] trustStorePassword, String trustStoreType) {
            if (Objects.isNull(trustStorePath) || ArrayUtils.isEmpty((char[])trustStorePassword) || StringUtils.isBlank((CharSequence)trustStoreType)) {
                throw new GenericKeyStoreException(TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE);
            }
            try {
                KeyStore trustStore = KeyStoreUtils.loadKeyStore(trustStorePath, trustStorePassword, trustStoreType);
                KeyStoreHolder trustStoreHolder = new KeyStoreHolder(trustStore, trustStorePassword);
                this.trustStores.add(trustStoreHolder);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException(KEY_STORE_LOADING_EXCEPTION, e);
            }
            return this;
        }

        public Builder withTrustStore(KeyStore trustStore, char[] trustStorePassword) {
            this.validateKeyStore(trustStore, trustStorePassword, TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE);
            KeyStoreHolder trustStoreHolder = new KeyStoreHolder(trustStore, trustStorePassword);
            this.trustStores.add(trustStoreHolder);
            return this;
        }

        public Builder withIdentity(String identityStorePath, char[] identityStorePassword) {
            return this.withIdentity(identityStorePath, identityStorePassword, identityStorePassword, KeyStore.getDefaultType());
        }

        public Builder withIdentity(String identityStorePath, char[] identityStorePassword, char[] identityPassword) {
            return this.withIdentity(identityStorePath, identityStorePassword, identityPassword, KeyStore.getDefaultType());
        }

        public Builder withIdentity(String identityStorePath, char[] identityStorePassword, String identityStoreType) {
            return this.withIdentity(identityStorePath, identityStorePassword, identityStorePassword, identityStoreType);
        }

        public Builder withIdentity(String identityStorePath, char[] identityStorePassword, char[] identityPassword, String identityStoreType) {
            if (StringUtils.isBlank((CharSequence)identityStorePath) || ArrayUtils.isEmpty((char[])identityStorePassword) || StringUtils.isBlank((CharSequence)identityStoreType)) {
                throw new GenericKeyStoreException(IDENTITY_VALIDATION_EXCEPTION_MESSAGE);
            }
            try {
                KeyStore identity = KeyStoreUtils.loadKeyStore(identityStorePath, identityStorePassword, identityStoreType);
                KeyStoreHolder identityHolder = new KeyStoreHolder(identity, identityStorePassword, identityPassword);
                this.identities.add(identityHolder);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException(KEY_STORE_LOADING_EXCEPTION, e);
            }
            return this;
        }

        public Builder withIdentity(Path identityStorePath, char[] identityStorePassword) {
            return this.withIdentity(identityStorePath, identityStorePassword, identityStorePassword, KeyStore.getDefaultType());
        }

        public Builder withIdentity(Path identityStorePath, char[] identityStorePassword, char[] identityPassword) {
            return this.withIdentity(identityStorePath, identityStorePassword, identityPassword, KeyStore.getDefaultType());
        }

        public Builder withIdentity(Path identityStorePath, char[] identityStorePassword, String identityStoreType) {
            return this.withIdentity(identityStorePath, identityStorePassword, identityStorePassword, identityStoreType);
        }

        public Builder withIdentity(Path identityStorePath, char[] identityStorePassword, char[] identityPassword, String identityStoreType) {
            if (Objects.isNull(identityStorePath) || ArrayUtils.isEmpty((char[])identityStorePassword) || StringUtils.isBlank((CharSequence)identityStoreType)) {
                throw new GenericKeyStoreException(IDENTITY_VALIDATION_EXCEPTION_MESSAGE);
            }
            try {
                KeyStore identity = KeyStoreUtils.loadKeyStore(identityStorePath, identityStorePassword, identityStoreType);
                KeyStoreHolder identityHolder = new KeyStoreHolder(identity, identityStorePassword, identityPassword);
                this.identities.add(identityHolder);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException(KEY_STORE_LOADING_EXCEPTION, e);
            }
            return this;
        }

        public Builder withIdentity(KeyStore identityStore, char[] identityStorePassword) {
            return this.withIdentity(identityStore, identityStorePassword, identityStorePassword);
        }

        public Builder withIdentity(KeyStore identityStore, char[] identityStorePassword, char[] identityPassword) {
            this.validateKeyStore(identityStore, identityStorePassword, IDENTITY_VALIDATION_EXCEPTION_MESSAGE);
            KeyStoreHolder identityHolder = new KeyStoreHolder(identityStore, identityStorePassword, identityPassword);
            this.identities.add(identityHolder);
            return this;
        }

        public Builder withKeyManager(X509ExtendedKeyManager keyManager) {
            this.identityManagers.add(keyManager);
            return this;
        }

        private void validateKeyStore(KeyStore keyStore, char[] keyStorePassword, String exceptionMessage) {
            if (Objects.isNull(keyStore) || ArrayUtils.isEmpty((char[])keyStorePassword)) {
                throw new GenericKeyStoreException(exceptionMessage);
            }
        }

        public Builder withHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder withProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder withSecureRandom(SecureRandom secureRandom) {
            this.secureRandom = secureRandom;
            return this;
        }

        public Builder withTrustingAllCertificatesWithoutValidation() {
            this.trustingAllCertificatesWithoutValidationEnabled = true;
            return this;
        }

        public Builder withPasswordCaching() {
            this.passwordCachingEnabled = true;
            return this;
        }

        public SSLFactory build() {
            if (this.isIdentityMaterialNotPresent() && this.isTrustMaterialNotPresent()) {
                throw new GenericSecurityException(IDENTITY_AND_TRUST_MATERIAL_VALIDATION_EXCEPTION_MESSAGE);
            }
            if (this.isTrustMaterialNotPresent()) {
                throw new GenericKeyStoreException(TRUST_STRATEGY_VALIDATION_EXCEPTION_MESSAGE);
            }
            SSLFactory sslFactory = new SSLFactory(this.protocol, this.secureRandom, this.hostnameVerifier, this.identities, this.identityManagers, this.trustStores, this.trustManagers, this.includeDefaultJdkTrustStore, this.trustingAllCertificatesWithoutValidationEnabled, this.passwordCachingEnabled);
            if (this.isIdentityMaterialPresent() && this.isTrustMaterialPresent()) {
                sslFactory.createSSLContextWithKeyMaterialAndTrustMaterial();
            }
            if (this.isIdentityMaterialNotPresent() && this.isTrustMaterialPresent()) {
                sslFactory.createSSLContextWithTrustMaterial();
            }
            return sslFactory;
        }

        private boolean isTrustMaterialPresent() {
            return !this.trustStores.isEmpty() || !this.trustManagers.isEmpty() || this.includeDefaultJdkTrustStore || this.trustingAllCertificatesWithoutValidationEnabled;
        }

        private boolean isTrustMaterialNotPresent() {
            return !this.isTrustMaterialPresent();
        }

        private boolean isIdentityMaterialPresent() {
            return !this.identities.isEmpty() || !this.identityManagers.isEmpty();
        }

        private boolean isIdentityMaterialNotPresent() {
            return !this.isIdentityMaterialPresent();
        }
    }
}

