/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.log.mapper;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import nl.altindag.log.mapper.MarkerMapper;
import nl.altindag.log.model.LogEvent;

public final class LogEventMapper
implements Function<ILoggingEvent, LogEvent> {
    private static final LogEventMapper INSTANCE = new LogEventMapper();

    private LogEventMapper() {
    }

    @Override
    public LogEvent apply(ILoggingEvent iLoggingEvent) {
        String message = iLoggingEvent.getMessage();
        String formattedMessage = iLoggingEvent.getFormattedMessage();
        String level = iLoggingEvent.getLevel().toString();
        String loggerName = iLoggingEvent.getLoggerName();
        String threadName = iLoggingEvent.getThreadName();
        ZonedDateTime timeStamp = ZonedDateTime.ofInstant(Instant.ofEpochMilli(iLoggingEvent.getTimeStamp()), ZoneOffset.UTC);
        Map<String, String> diagnosticContext = Collections.unmodifiableMap(iLoggingEvent.getMDCPropertyMap());
        List keyValuePairs = iLoggingEvent.getKeyValuePairs() == null ? Collections.emptyList() : iLoggingEvent.getKeyValuePairs().stream().map(keyValuePair -> new AbstractMap.SimpleImmutableEntry<String, Object>(keyValuePair.key, keyValuePair.value)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        List arguments = Optional.ofNullable(iLoggingEvent.getArgumentArray()).map(Arrays::asList).map(Collections::unmodifiableList).orElseGet(Collections::emptyList);
        Throwable throwable = Optional.ofNullable(iLoggingEvent.getThrowableProxy()).filter(ThrowableProxy.class::isInstance).map(ThrowableProxy.class::cast).map(ThrowableProxy::getThrowable).orElse(null);
        List logMarkers = Collections.emptyList();
        if (iLoggingEvent.getMarkerList() != null) {
            logMarkers = iLoggingEvent.getMarkerList().stream().map(MarkerMapper.getInstance()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return new LogEvent(message, formattedMessage, level, loggerName, threadName, timeStamp, arguments, throwable, diagnosticContext, keyValuePairs, logMarkers);
    }

    public static LogEventMapper getInstance() {
        return INSTANCE;
    }
}

