/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.LifeCycle;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import nl.altindag.log.appender.InMemoryAppender;
import nl.altindag.log.model.LogEvent;
import nl.altindag.log.util.JavaUtilLoggingLoggerUtils;
import nl.altindag.log.util.LogbackUtils;
import nl.altindag.log.util.Mappers;

public final class LogCaptor
implements AutoCloseable {
    private static final Map<String, Level> LOG_LEVEL_CONTAINER = new HashMap<String, Level>();
    private static final List<String> CONSOLE_APPENDER_NAMES = Arrays.asList("console", "CONSOLE");
    private final Logger logger;
    private final Appender<ILoggingEvent> appender;
    private final List<ILoggingEvent> eventsCollector = new CopyOnWriteArrayList<ILoggingEvent>();

    private LogCaptor(String loggerName) {
        this.logger = LogbackUtils.getLogger(loggerName);
        this.appender = new InMemoryAppender<ILoggingEvent>("log-captor", this.eventsCollector);
        this.appender.start();
        this.logger.addAppender(this.appender);
        JavaUtilLoggingLoggerUtils.redirectToSlf4j(loggerName);
        LOG_LEVEL_CONTAINER.putIfAbsent(this.logger.getName(), this.logger.getEffectiveLevel());
    }

    public static LogCaptor forRoot() {
        return new LogCaptor("ROOT");
    }

    public static LogCaptor forClass(Class<?> clazz) {
        return new LogCaptor(clazz.getName());
    }

    public static LogCaptor forName(String name) {
        return new LogCaptor(name);
    }

    public List<String> getLogs() {
        return this.getLogs(logEvent -> true, ILoggingEvent::getFormattedMessage);
    }

    public List<String> getInfoLogs() {
        return this.getLogs(Level.INFO);
    }

    public List<String> getDebugLogs() {
        return this.getLogs(Level.DEBUG);
    }

    public List<String> getWarnLogs() {
        return this.getLogs(Level.WARN);
    }

    public List<String> getErrorLogs() {
        return this.getLogs(Level.ERROR);
    }

    public List<String> getTraceLogs() {
        return this.getLogs(Level.TRACE);
    }

    private List<String> getLogs(Level level) {
        return this.getLogs(logEvent -> logEvent.getLevel() == level, ILoggingEvent::getFormattedMessage);
    }

    public List<LogEvent> getLogEvents() {
        return this.getLogs(logEvent -> true, Mappers.toLogEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> getLogs(Predicate<ILoggingEvent> logEventPredicate, Function<ILoggingEvent, T> logEventMapper) {
        List<ILoggingEvent> list = this.eventsCollector;
        synchronized (list) {
            return this.eventsCollector.stream().filter(logEventPredicate).map(logEventMapper).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
    }

    public boolean hasMessage(String message) {
        return this.getLogs().stream().anyMatch(log -> log.contains(message));
    }

    public boolean hasInfoMessage(String message) {
        return this.hasMessage(Level.INFO, message);
    }

    public boolean hasDebugMessage(String message) {
        return this.hasMessage(Level.DEBUG, message);
    }

    public boolean hasWarnMessage(String message) {
        return this.hasMessage(Level.WARN, message);
    }

    public boolean hasErrorMessage(String message) {
        return this.hasMessage(Level.ERROR, message);
    }

    public boolean hasTraceMessage(String message) {
        return this.hasMessage(Level.TRACE, message);
    }

    private boolean hasMessage(Level level, String message) {
        return this.getLogs(logEvent -> logEvent.getLevel() == level, ILoggingEvent::getFormattedMessage).stream().anyMatch(log -> log.contains(message));
    }

    public void addFilter(Filter<ILoggingEvent> filter) {
        this.appender.addFilter(filter);
        filter.start();
    }

    public void setLogLevelToInfo() {
        this.logger.setLevel(Level.INFO);
    }

    public void setLogLevelToDebug() {
        this.logger.setLevel(Level.DEBUG);
    }

    public void setLogLevelToTrace() {
        this.logger.setLevel(Level.TRACE);
    }

    public void disableLogs() {
        this.logger.setLevel(Level.OFF);
    }

    public void disableConsoleOutput() {
        this.getConsoleAppender().ifPresent(LifeCycle::stop);
    }

    public void enableConsoleOutput() {
        this.getConsoleAppender().ifPresent(LifeCycle::start);
    }

    Optional<Appender<ILoggingEvent>> getConsoleAppender() {
        Logger rootLogger = this.logger.getLoggerContext().getLogger("ROOT");
        return CONSOLE_APPENDER_NAMES.stream().map(arg_0 -> ((Logger)rootLogger).getAppender(arg_0)).filter(Objects::nonNull).findFirst();
    }

    public void resetLogLevel() {
        Optional.ofNullable(LOG_LEVEL_CONTAINER.get(this.logger.getName())).ifPresent(arg_0 -> ((Logger)this.logger).setLevel(arg_0));
    }

    public void clearLogs() {
        this.eventsCollector.clear();
    }

    @Override
    public void close() {
        this.logger.detachAppender(this.appender);
        this.appender.stop();
    }

    public String toString() {
        return "LogCaptor(loggerName=" + this.logger.getName() + ")";
    }
}

