/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.retrievers;

import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Map;
import java.util.stream.Collectors;

public class GraphQLInputObjectRetriever {
    public GraphQLInputType getInputObject(GraphQLType graphQLType, String newNamePrefix, Map<String, GraphQLType> typeRegistry) {
        if (graphQLType instanceof GraphQLObjectType) {
            return this.handleGraphQLObjectType((GraphQLObjectType)graphQLType, newNamePrefix, typeRegistry);
        }
        if (graphQLType instanceof GraphQLList) {
            return new GraphQLList((GraphQLType)this.getInputObject(((GraphQLList)graphQLType).getWrappedType(), newNamePrefix, typeRegistry));
        }
        if (graphQLType instanceof GraphQLNonNull) {
            return new GraphQLNonNull((GraphQLType)this.getInputObject(((GraphQLNonNull)graphQLType).getWrappedType(), newNamePrefix, typeRegistry));
        }
        if (graphQLType instanceof GraphQLTypeReference) {
            return new GraphQLTypeReference(newNamePrefix + graphQLType.getName());
        }
        if (graphQLType instanceof GraphQLInputType) {
            return (GraphQLInputType)graphQLType;
        }
        throw new IllegalArgumentException("Cannot convert type to input : " + graphQLType);
    }

    private GraphQLInputType handleGraphQLObjectType(GraphQLObjectType graphQLType, String newNamePrefix, Map<String, GraphQLType> typeRegistry) {
        GraphQLObjectType object = graphQLType;
        String newObjectName = newNamePrefix + object.getName();
        GraphQLType objectInTypeRegistry = typeRegistry.get(newObjectName);
        if (objectInTypeRegistry != null && objectInTypeRegistry instanceof GraphQLInputType) {
            return (GraphQLInputType)objectInTypeRegistry;
        }
        GraphQLInputObjectType inputObjectType = new GraphQLInputObjectType(newObjectName, object.getDescription(), object.getFieldDefinitions().stream().map(field -> {
            GraphQLOutputType type = field.getType();
            GraphQLInputType inputType = this.getInputObject((GraphQLType)type, newNamePrefix, typeRegistry);
            return new GraphQLInputObjectField(field.getName(), field.getDescription(), inputType, null);
        }).collect(Collectors.toList()));
        typeRegistry.put(inputObjectType.getName(), (GraphQLType)inputObjectType);
        return inputObjectType;
    }
}

