/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.retrievers;

import graphql.annotations.GraphQLFieldDefinitionWrapper;
import graphql.annotations.annotationTypes.GraphQLRelayMutation;
import graphql.annotations.connection.GraphQLConnection;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.CannotCastMemberException;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.retrievers.GraphQLInputObjectRetriever;
import graphql.annotations.processor.retrievers.GraphQLObjectInfoRetriever;
import graphql.annotations.processor.retrievers.fieldBuilders.ArgumentBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.DeprecateBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.DescriptionBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.field.FieldDataFetcherBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.field.FieldNameBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.method.MethodDataFetcherBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.method.MethodNameBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.method.MethodTypeBuilder;
import graphql.annotations.processor.searchAlgorithms.BreadthFirstSearch;
import graphql.annotations.processor.searchAlgorithms.ParentalSearch;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.annotations.processor.util.ConnectionUtil;
import graphql.annotations.processor.util.DataFetcherConstructor;
import graphql.annotations.processor.util.ObjectUtil;
import graphql.annotations.processor.util.ReflectionKit;
import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.StaticDataFetcher;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GraphQLFieldRetriever {
    private GraphQLObjectInfoRetriever graphQLObjectInfoRetriever;
    private BreadthFirstSearch breadthFirstSearch;
    private ParentalSearch parentalSearch;
    private GraphQLInputObjectRetriever graphQLInputObjectRetriever;
    private DataFetcherConstructor dataFetcherConstructor;

    public GraphQLFieldRetriever(GraphQLObjectInfoRetriever graphQLObjectInfoRetriever, BreadthFirstSearch breadthFirstSearch, ParentalSearch parentalSearch, GraphQLInputObjectRetriever graphQLInputObjectRetriever, DataFetcherConstructor dataFetcherConstructor) {
        this.graphQLObjectInfoRetriever = graphQLObjectInfoRetriever;
        this.breadthFirstSearch = breadthFirstSearch;
        this.parentalSearch = parentalSearch;
        this.graphQLInputObjectRetriever = graphQLInputObjectRetriever;
        this.dataFetcherConstructor = dataFetcherConstructor;
    }

    public GraphQLFieldRetriever() {
        this(new GraphQLObjectInfoRetriever(), new BreadthFirstSearch(new GraphQLObjectInfoRetriever()), new ParentalSearch(new GraphQLObjectInfoRetriever()), new GraphQLInputObjectRetriever(), new DataFetcherConstructor());
    }

    public List<GraphQLFieldDefinition> getExtensionFields(Class<?> object, List<String> fieldsDefined, ProcessingElementsContainer container) throws CannotCastMemberException {
        ArrayList<GraphQLFieldDefinition> fields = new ArrayList<GraphQLFieldDefinition>();
        if (container.getExtensionsTypeRegistry().containsKey(object)) {
            for (Class<?> aClass : container.getExtensionsTypeRegistry().get(object)) {
                for (Method method : this.graphQLObjectInfoRetriever.getOrderedMethods(aClass)) {
                    if (method.isBridge() || method.isSynthetic() || !this.breadthFirstSearch.isFound(method)) continue;
                    this.addExtensionField(this.getField(method, container), fields, fieldsDefined);
                }
                for (Field field : ObjectUtil.getAllFields(aClass).values()) {
                    if (Modifier.isStatic(field.getModifiers()) || !this.parentalSearch.isFound(field)) continue;
                    this.addExtensionField(this.getField(field, container), fields, fieldsDefined);
                }
            }
        }
        return fields;
    }

    public GraphQLFieldDefinition getField(Method method, ProcessingElementsContainer container) throws GraphQLAnnotationsException {
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        TypeFunction typeFunction = this.getTypeFunction(method, container);
        builder.name(new MethodNameBuilder(method).build());
        GraphQLOutputType outputType = new MethodTypeBuilder(method, typeFunction, container).build();
        boolean isConnection = ConnectionUtil.isConnection(method, outputType);
        if (isConnection) {
            outputType = this.getGraphQLConnection(method, outputType, container.getRelay(), container.getTypeRegistry());
        }
        builder.type(outputType);
        this.handleConnectionArgument(container, builder, isConnection);
        Object args = new ArgumentBuilder(method, typeFunction, this.graphQLInputObjectRetriever, builder, container, outputType).build();
        GraphQLFieldDefinition relayFieldDefinition = this.handleRelayArguments(method, container, builder, outputType, (List<GraphQLArgument>)args);
        builder.description(new DescriptionBuilder(method).build()).deprecate(new DeprecateBuilder(method).build()).dataFetcher(new MethodDataFetcherBuilder(method, outputType, typeFunction, container, relayFieldDefinition, (List<GraphQLArgument>)args, this.dataFetcherConstructor, isConnection).build());
        return new GraphQLFieldDefinitionWrapper(builder.build());
    }

    private GraphQLFieldDefinition handleRelayArguments(Method method, ProcessingElementsContainer container, GraphQLFieldDefinition.Builder builder, GraphQLOutputType outputType, List<GraphQLArgument> args) {
        GraphQLFieldDefinition relayFieldDefinition = null;
        if (method.isAnnotationPresent(GraphQLRelayMutation.class)) {
            relayFieldDefinition = this.buildRelayMutation(method, container, builder, outputType, args);
        } else {
            builder.argument(args);
        }
        return relayFieldDefinition;
    }

    private void handleConnectionArgument(ProcessingElementsContainer container, GraphQLFieldDefinition.Builder builder, boolean isConnection) {
        if (isConnection) {
            builder.argument(container.getRelay().getConnectionFieldArguments());
        }
    }

    private TypeFunction getTypeFunction(Method method, ProcessingElementsContainer container) {
        graphql.annotations.annotationTypes.GraphQLType annotation = method.getAnnotation(graphql.annotations.annotationTypes.GraphQLType.class);
        TypeFunction typeFunction = container.getDefaultTypeFunction();
        if (annotation != null) {
            typeFunction = ReflectionKit.newInstance(annotation.value());
        }
        return typeFunction;
    }

    private GraphQLFieldDefinition buildRelayMutation(Method method, ProcessingElementsContainer container, GraphQLFieldDefinition.Builder builder, GraphQLOutputType outputType, List<GraphQLArgument> args) {
        if (!(outputType instanceof GraphQLObjectType) && !(outputType instanceof GraphQLInterfaceType)) {
            throw new RuntimeException("outputType should be an object or an interface");
        }
        StringBuilder titleBuffer = new StringBuilder(method.getName());
        titleBuffer.setCharAt(0, Character.toUpperCase(titleBuffer.charAt(0)));
        String title = titleBuffer.toString();
        List fieldDefinitions = outputType instanceof GraphQLObjectType ? ((GraphQLObjectType)outputType).getFieldDefinitions() : ((GraphQLInterfaceType)outputType).getFieldDefinitions();
        GraphQLFieldDefinition relayFieldDefinition = container.getRelay().mutationWithClientMutationId(title, method.getName(), args.stream().map(t -> GraphQLInputObjectField.newInputObjectField().name(t.getName()).type(t.getType()).description(t.getDescription()).build()).collect(Collectors.toList()), fieldDefinitions, (DataFetcher)new StaticDataFetcher(null));
        builder.argument(relayFieldDefinition.getArguments()).type(relayFieldDefinition.getType());
        return relayFieldDefinition;
    }

    public GraphQLFieldDefinition getField(Field field, ProcessingElementsContainer container) throws GraphQLAnnotationsException {
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        builder.name(new FieldNameBuilder(field).build());
        TypeFunction typeFunction = this.getTypeFunction(field, container);
        GraphQLOutputType outputType = (GraphQLOutputType)typeFunction.buildType(field.getType(), field.getAnnotatedType(), container);
        boolean isConnection = ConnectionUtil.isConnection(field, outputType);
        if (isConnection) {
            outputType = this.getGraphQLConnection(field, outputType, container.getRelay(), container.getTypeRegistry());
            builder.argument(container.getRelay().getConnectionFieldArguments());
        }
        builder.type(outputType).description(new DescriptionBuilder(field).build()).deprecate(new DeprecateBuilder(field).build()).dataFetcher(new FieldDataFetcherBuilder(field, this.dataFetcherConstructor, outputType, typeFunction, container, isConnection).build());
        return new GraphQLFieldDefinitionWrapper(builder.build());
    }

    private TypeFunction getTypeFunction(Field field, ProcessingElementsContainer container) {
        graphql.annotations.annotationTypes.GraphQLType annotation = field.getAnnotation(graphql.annotations.annotationTypes.GraphQLType.class);
        TypeFunction typeFunction = container.getDefaultTypeFunction();
        if (annotation != null) {
            typeFunction = ReflectionKit.newInstance(annotation.value());
        }
        return typeFunction;
    }

    private GraphQLOutputType getGraphQLConnection(AccessibleObject field, GraphQLOutputType type, Relay relay, Map<String, GraphQLType> typeRegistry) {
        if (type instanceof GraphQLNonNull) {
            GraphQLList listType = (GraphQLList)((GraphQLNonNull)type).getWrappedType();
            return new GraphQLNonNull((GraphQLType)this.internalGetGraphQLConnection(field, listType, relay, typeRegistry));
        }
        return this.internalGetGraphQLConnection(field, (GraphQLList)type, relay, typeRegistry);
    }

    private GraphQLOutputType internalGetGraphQLConnection(AccessibleObject field, GraphQLList listType, Relay relay, Map<String, GraphQLType> typeRegistry) {
        GraphQLOutputType wrappedType = (GraphQLOutputType)listType.getWrappedType();
        String connectionName = field.getAnnotation(GraphQLConnection.class).name();
        connectionName = connectionName.isEmpty() ? wrappedType.getName() : connectionName;
        GraphQLObjectType edgeType = this.getActualType(relay.edgeType(connectionName, wrappedType, null, Collections.emptyList()), typeRegistry);
        return this.getActualType(relay.connectionType(connectionName, edgeType, Collections.emptyList()), typeRegistry);
    }

    private void addExtensionField(GraphQLFieldDefinition gqlField, List<GraphQLFieldDefinition> fields, List<String> fieldsDefined) {
        if (fieldsDefined.contains(gqlField.getName())) {
            throw new GraphQLAnnotationsException("Duplicate field found in extension : " + gqlField.getName(), null);
        }
        fieldsDefined.add(gqlField.getName());
        fields.add(gqlField);
    }

    private GraphQLObjectType getActualType(GraphQLObjectType type, Map<String, GraphQLType> typeRegistry) {
        if (typeRegistry.containsKey(type.getName())) {
            type = (GraphQLObjectType)typeRegistry.get(type.getName());
        } else {
            typeRegistry.put(type.getName(), (GraphQLType)type);
        }
        return type;
    }
}

