/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.retrievers.fieldBuilders;

import graphql.annotations.annotationTypes.GraphQLDefaultValue;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.directives.DirectiveWirer;
import graphql.annotations.directives.DirectiveWiringMapRetriever;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.retrievers.fieldBuilders.Builder;
import graphql.annotations.processor.retrievers.fieldBuilders.DirectivesBuilder;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.annotations.processor.util.NamingKit;
import graphql.annotations.processor.util.ReflectionKit;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLOutputType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ArgumentBuilder
implements Builder<List<GraphQLArgument>> {
    private Method method;
    private TypeFunction typeFunction;
    private GraphQLFieldDefinition.Builder builder;
    private ProcessingElementsContainer container;
    private GraphQLOutputType outputType;

    public ArgumentBuilder(Method method, TypeFunction typeFunction, GraphQLFieldDefinition.Builder builder, ProcessingElementsContainer container, GraphQLOutputType outputType) {
        this.method = method;
        this.typeFunction = typeFunction;
        this.builder = builder;
        this.container = container;
        this.outputType = outputType;
    }

    @Override
    public List<GraphQLArgument> build() {
        TypeFunction finalTypeFunction = this.typeFunction;
        List<GraphQLArgument> args = Arrays.stream(this.method.getParameters()).filter(p -> !DataFetchingEnvironment.class.isAssignableFrom(p.getType())).map(parameter -> {
            Class<?> t = parameter.getType();
            GraphQLInputType graphQLType = (GraphQLInputType)finalTypeFunction.buildType(true, t, parameter.getAnnotatedType(), this.container);
            return this.getArgument((Parameter)parameter, graphQLType);
        }).collect(Collectors.toList());
        return args;
    }

    private GraphQLArgument getArgument(Parameter parameter, GraphQLInputType inputType) throws GraphQLAnnotationsException {
        GraphQLName name;
        GraphQLDefaultValue defaultValue;
        GraphQLArgument.Builder argumentBuilder = GraphQLArgument.newArgument().type(inputType);
        GraphQLDescription description = parameter.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            argumentBuilder.description(description.value());
        }
        if ((defaultValue = parameter.getAnnotation(GraphQLDefaultValue.class)) != null) {
            argumentBuilder.defaultValue(ReflectionKit.newInstance(defaultValue.value()).get());
        }
        if ((name = parameter.getAnnotation(GraphQLName.class)) != null) {
            argumentBuilder.name(NamingKit.toGraphqlName(name.value()));
        } else {
            argumentBuilder.name(NamingKit.toGraphqlName(parameter.getName()));
        }
        argumentBuilder.withDirectives(new DirectivesBuilder(parameter, this.container).build());
        return (GraphQLArgument)new DirectiveWirer().wire((GraphQLDirectiveContainer)argumentBuilder.build(), new DirectiveWiringMapRetriever().getDirectiveWiringMap(parameter, this.container), this.container.getCodeRegistryBuilder(), inputType.getName());
    }
}

