/*
 * Decompiled with CFR 0.152.
 */
package com.ai.face.base.utils;

import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.os.Handler;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import android.util.Log;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Queue;

public class TextToSpeechManager
implements TextToSpeech.OnInitListener {
    private static final String TAG = "TextToSpeechManager";
    private Context context;
    private TextToSpeech textToSpeech;
    private boolean isTTSReady = false;
    private final Queue<String> speechQueue = new LinkedList<String>();
    private boolean isSpeaking = false;
    private Ill1\u4e28Iil01Ii onSpeechCompletedListener;
    private Iil01IL\u4e28IIi1 initializationCompletedListener;
    private String messageToSpeakAfterInit;
    private boolean isInitializing = false;
    private Locale locale;

    public TextToSpeechManager(Context context, Locale locale) {
        this.context = context;
        this.locale = locale;
        new Handler().postDelayed(this::initializeTextToSpeech, 200L);
    }

    private void initializeTextToSpeech() {
        if (!this.isInitializing) {
            TextToSpeechManager textToSpeechManager = this;
            textToSpeechManager.isInitializing = true;
            textToSpeechManager.textToSpeech = new TextToSpeech(this.context, (TextToSpeech.OnInitListener)this);
        }
    }

    private void handleInitializationFailure(String string2) {
        TextToSpeechManager textToSpeechManager = textToSpeechManager3;
        textToSpeechManager.isInitializing = false;
        textToSpeechManager.isTTSReady = false;
        Log.e((String)TAG, (String)("TTS Initialization failed: " + string2));
        if (string2.contains("missing data")) {
            Intent intent;
            TextToSpeechManager textToSpeechManager2 = textToSpeechManager3;
            TextToSpeechManager textToSpeechManager3 = intent;
            new Intent().setAction("android.speech.tts.engine.INSTALL_TTS_DATA");
            textToSpeechManager3.addFlags(0x10000000);
            textToSpeechManager2.context.startActivity((Intent)textToSpeechManager3);
        }
    }

    private boolean isTTSSupported(Context context) {
        TextToSpeech textToSpeech;
        TextToSpeechManager textToSpeechManager = textToSpeech;
        boolean bl = false;
        int n2 = new TextToSpeech(context, n -> {}).isLanguageAvailable(Locale.US);
        if (n2 != -1 && n2 != -2) {
            bl = true;
        }
        textToSpeechManager.shutdown();
        return bl;
    }

    private void setMaxVolume() {
        TextToSpeechManager textToSpeechManager = (AudioManager)textToSpeechManager.context.getSystemService("audio");
        if (textToSpeechManager.getStreamVolume(3) == 0) {
            TextToSpeechManager textToSpeechManager2 = textToSpeechManager;
            textToSpeechManager2.setStreamVolume(3, textToSpeechManager2.getStreamMaxVolume(3) / 2, 0);
        }
    }

    private void setTTSProgressListener() {
        this.textToSpeech.setOnUtteranceProgressListener(new UtteranceProgressListener(){

            public void onStart(String string2) {
                TextToSpeechManager.this.isSpeaking = true;
            }

            public void onDone(String string2) {
                Ii\u4e281Iil01Ii ii\u4e281Iil01Ii = this;
                ii\u4e281Iil01Ii.TextToSpeechManager.this.isSpeaking = false;
                ii\u4e281Iil01Ii.TextToSpeechManager.this.playNextInQueue();
                ii\u4e281Iil01Ii.TextToSpeechManager.this.getClass();
            }

            public void onError(String string2) {
                Ii\u4e281Iil01Ii ii\u4e281Iil01Ii = this;
                ii\u4e281Iil01Ii.TextToSpeechManager.this.isSpeaking = false;
                ii\u4e281Iil01Ii.TextToSpeechManager.this.playNextInQueue();
                ii\u4e281Iil01Ii.TextToSpeechManager.this.getClass();
            }
        });
    }

    private void enqueueMessage(String string2) {
        if (!this.isEmptyOrNull(string2)) {
            TextToSpeechManager textToSpeechManager = this;
            textToSpeechManager.speechQueue.add(string2);
            if (!textToSpeechManager.isSpeaking && this.isTTSReady) {
                this.isSpeaking = true;
                this.playNextInQueue();
            }
        }
    }

    private void playNextInQueue() {
        if (!((TextToSpeechManager)((Object)string2)).speechQueue.isEmpty() && ((TextToSpeechManager)((Object)string2)).isTTSReady) {
            TextToSpeechManager textToSpeechManager = string2;
            String string2 = textToSpeechManager.speechQueue.poll();
            textToSpeechManager.textToSpeech.speak((CharSequence)string2, 0, null, string2);
        }
    }

    private boolean isEmptyOrNull(String string2) {
        return string2 == null || string2.trim().isEmpty() || string2.trim().equalsIgnoreCase("null");
    }

    public void onInit(int n) {
        if (n == 0) {
            n = this.textToSpeech.setLanguage(this.locale);
            if (n != -1 && n != -2) {
                this.isTTSReady = true;
                this.isInitializing = false;
                String string2 = this.messageToSpeakAfterInit;
                if (string2 != null) {
                    this.speak(string2);
                    this.messageToSpeakAfterInit = null;
                }
                this.setTTSProgressListener();
            } else {
                Log.e((String)TAG, (String)"Language not supported or missing data.");
                this.handleInitializationFailure("Language not supported or missing data.");
            }
        } else {
            Log.e((String)TAG, (String)("Initialization failed with status: " + n));
            this.handleInitializationFailure("Initialization failed with status: " + n);
        }
    }

    public void speak(String string2) {
        this.speak(string2, null);
    }

    public void speak(String string2, Ill1\u4e28Iil01Ii ill1\u4e28Iil01Ii) {
        if (this.textToSpeech != null && this.isTTSReady) {
            this.enqueueMessage(string2);
        } else {
            this.initializeTextToSpeech();
            this.messageToSpeakAfterInit = string2;
        }
    }

    public void shutdown() {
        TextToSpeech textToSpeech = this.textToSpeech;
        if (textToSpeech != null) {
            textToSpeech.stop();
            this.textToSpeech.shutdown();
            this.textToSpeech = null;
            this.isTTSReady = false;
            this.isSpeaking = false;
        }
    }

    public void stop() {
        TextToSpeech textToSpeech;
        if (this.isTTSReady && (textToSpeech = this.textToSpeech) != null) {
            this.isSpeaking = false;
            textToSpeech.stop();
        }
    }

    public boolean isTTSReady() {
        return this.isTTSReady;
    }

    public void setOnInitializationCompletedListener(Iil01IL\u4e28IIi1 iil01IL\u4e28IIi1) {
    }

    public static interface Iil01IL\u4e28IIi1 {
    }

    public static interface Ill1\u4e28Iil01Ii {
    }
}

