/*
 * Decompiled with CFR 0.152.
 */
package com.eason.network;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0007J\b\u0010\u0011\u001a\u00020\u000fH\u0007J\b\u0010\u0012\u001a\u00020\u000fH\u0007J\u0006\u0010\u0013\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/eason/network/NetworkManager;", "", "()V", "connectivityManager", "Landroid/net/ConnectivityManager;", "wifiManager", "Landroid/net/wifi/WifiManager;", "getBssid", "", "getWiFiSSID", "init", "", "context", "Landroid/content/Context;", "is5GSupported", "", "isCellular", "isInternetConnected", "isWiFiConnected", "isWiFiEnable", "network_release"})
public final class NetworkManager {
    private static WifiManager wifiManager;
    private static ConnectivityManager connectivityManager;
    @NotNull
    public static final NetworkManager INSTANCE;

    public final void init(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getApplicationContext().getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        wifiManager = (WifiManager)object;
        Object object2 = context.getApplicationContext().getSystemService("connectivity");
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        connectivityManager = (ConnectivityManager)object2;
    }

    @SuppressLint(value={"MissingPermission"})
    public final boolean isWiFiConnected() {
        boolean bl;
        if (Build.VERSION.SDK_INT >= 23) {
            ConnectivityManager connectivityManager = NetworkManager.connectivityManager;
            if (connectivityManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"connectivityManager");
            }
            ConnectivityManager connectivityManager2 = NetworkManager.connectivityManager;
            if (connectivityManager2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"connectivityManager");
            }
            Network network = connectivityManager2.getActiveNetwork();
            Intrinsics.checkNotNull((Object)network);
            NetworkCapabilities capabilities = connectivityManager.getNetworkCapabilities(network);
            bl = capabilities != null && capabilities.hasTransport(1);
        } else {
            ConnectivityManager connectivityManager = NetworkManager.connectivityManager;
            if (connectivityManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"connectivityManager");
            }
            if (connectivityManager.getActiveNetworkInfo() != null) {
                ConnectivityManager connectivityManager3 = NetworkManager.connectivityManager;
                if (connectivityManager3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connectivityManager");
                }
                NetworkInfo networkInfo = connectivityManager3.getActiveNetworkInfo();
                Intrinsics.checkNotNull((Object)networkInfo);
                Intrinsics.checkNotNullExpressionValue((Object)networkInfo, (String)"connectivityManager.activeNetworkInfo!!");
                bl = networkInfo.getType() == 1;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @SuppressLint(value={"MissingPermission"})
    public final boolean isInternetConnected() {
        NetworkCapabilities capabilities;
        ConnectivityManager connectivityManager = NetworkManager.connectivityManager;
        if (connectivityManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"connectivityManager");
        }
        Network network = connectivityManager.getActiveNetwork();
        ConnectivityManager connectivityManager2 = NetworkManager.connectivityManager;
        if (connectivityManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"connectivityManager");
        }
        return (capabilities = connectivityManager2.getNetworkCapabilities(network)) != null && capabilities.hasCapability(16);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final String getWiFiSSID() {
        block5: {
            block4: {
                if (!this.isInternetConnected()) break block4;
                v0 = NetworkManager.wifiManager;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"wifiManager");
                }
                v1 = wifiInfo = v0.getConnectionInfo();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"wifiInfo");
                len = v1.getSSID().length();
                v2 = wifiInfo.getSSID();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"wifiInfo.ssid");
                if (!StringsKt.startsWith$default((String)v2, (String)"\"", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v3 = wifiInfo.getSSID();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"wifiInfo.ssid");
                if (StringsKt.endsWith$default((String)v3, (String)"\"", (boolean)false, (int)2, null)) {
                    v4 = wifiInfo.getSSID();
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"wifiInfo.ssid");
                    var3_3 = v4;
                    var4_4 = 1;
                    var5_5 = len - 1;
                    var6_6 = false;
                    v5 = var3_3;
                    if (v5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    v6 = v5.substring(var4_4, var5_5);
                    v7 = v6;
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else lbl-1000:
                // 2 sources

                {
                    v7 = wifiInfo.getSSID();
                }
                v8 = v7;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"if (wifiInfo.ssid.starts\u2026fiInfo.ssid\n            }");
                break block5;
            }
            v8 = "";
        }
        return v8;
    }

    @NotNull
    public final String getBssid() {
        String string;
        if (this.isInternetConnected()) {
            WifiManager wifiManager = NetworkManager.wifiManager;
            if (wifiManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"wifiManager");
            }
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            Intrinsics.checkNotNullExpressionValue((Object)wifiInfo, (String)"wifiManager.connectionInfo");
            String string2 = wifiInfo.getBSSID();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"wifiManager.connectionInfo.bssid");
        } else {
            string = "";
        }
        return string;
    }

    @SuppressLint(value={"MissingPermission"})
    public final boolean isCellular() {
        NetworkCapabilities capabilities;
        if (Build.VERSION.SDK_INT >= 23) {
            ConnectivityManager connectivityManager = NetworkManager.connectivityManager;
            if (connectivityManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"connectivityManager");
            }
            ConnectivityManager connectivityManager2 = NetworkManager.connectivityManager;
            if (connectivityManager2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"connectivityManager");
            }
            Network network = connectivityManager2.getActiveNetwork();
            Intrinsics.checkNotNull((Object)network);
            capabilities = connectivityManager.getNetworkCapabilities(network);
        } else {
            ConnectivityManager connectivityManager = NetworkManager.connectivityManager;
            if (connectivityManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"connectivityManager");
            }
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)networkInfo, (String)"connectivityManager.acti\u2026tworkInfo ?: return false");
            NetworkInfo networkInfo2 = networkInfo;
            return networkInfo2.isAvailable() && networkInfo2.getSubtype() == 13;
        }
        return capabilities != null && capabilities.hasTransport(0);
    }

    public final boolean isWiFiEnable() {
        WifiManager wifiManager = NetworkManager.wifiManager;
        if (wifiManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wifiManager");
        }
        return wifiManager.isWifiEnabled();
    }

    public final boolean is5GSupported() {
        WifiManager wifiManager = NetworkManager.wifiManager;
        if (wifiManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wifiManager");
        }
        return wifiManager.is5GHzBandSupported();
    }

    private NetworkManager() {
    }

    static {
        NetworkManager networkManager;
        INSTANCE = networkManager = new NetworkManager();
    }
}

