/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.webview;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.AbsoluteLayout;
import android.widget.ProgressBar;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.webview.OnWebViewTitleChangeCallBack;
import com.didichuxing.doraemonkit.widget.webview.MyWebViewClient;

public class MyWebView
extends WebView {
    private ProgressBar mProgressBar;
    private MyWebViewClient mMyWebViewClient;
    OnWebViewTitleChangeCallBack callBack;
    private Activity mContainerActivity;

    public void setCallBack(OnWebViewTitleChangeCallBack callBack) {
        this.callBack = callBack;
    }

    public MyWebView(Context context) {
        super(MyWebView.getFixedContext(context));
        this.init(context);
    }

    public MyWebView(Context context, AttributeSet attrs) {
        super(MyWebView.getFixedContext(context), attrs);
        this.init(context);
    }

    public MyWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(MyWebView.getFixedContext(context), attrs, defStyleAttr);
        this.init(context);
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    private static Context getFixedContext(Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            return context.createConfigurationContext(new Configuration());
        }
        return context;
    }

    private void init(Context context) {
        if (!(context instanceof Activity)) {
            throw new RuntimeException("only support Activity context");
        }
        this.mContainerActivity = (Activity)context;
        WebSettings webSettings = this.getSettings();
        webSettings.setPluginState(WebSettings.PluginState.ON);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setAllowFileAccess(false);
        webSettings.setLoadsImagesAutomatically(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setBuiltInZoomControls(false);
        webSettings.setDefaultTextEncodingName("UTF-8");
        webSettings.setDomStorageEnabled(true);
        webSettings.setCacheMode(-1);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(false);
        if (Build.VERSION.SDK_INT < 18) {
            webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            MyWebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(0);
        }
        if (Build.VERSION.SDK_INT > 10 && Build.VERSION.SDK_INT < 17) {
            this.removeJavascriptInterface("searchBoxJavaBridge_");
            this.removeJavascriptInterface("accessibilityTraversal");
            this.removeJavascriptInterface("accessibility");
        }
        this.mMyWebViewClient = new MyWebViewClient();
        this.setWebViewClient(this.mMyWebViewClient);
        this.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                if (newProgress < 100) {
                    MyWebView.this.showLoadProgress(newProgress);
                } else {
                    MyWebView.this.hideLoadProgress();
                }
            }

            public void onReceivedTitle(WebView view, String title) {
                super.onReceivedTitle(view, title);
                if (MyWebView.this.callBack != null) {
                    MyWebView.this.callBack.onChange(title);
                }
            }
        });
        this.addProgressView();
    }

    public void addInvokeListener(MyWebViewClient.InvokeListener listener) {
        this.mMyWebViewClient.addInvokeListener(listener);
    }

    public void removeInvokeListener(MyWebViewClient.InvokeListener listener) {
        this.mMyWebViewClient.removeInvokeListener(listener);
    }

    private void addProgressView() {
        this.mProgressBar = new ProgressBar(this.getContext(), null, 16842872);
        this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(-1, 10, 0, 0));
        Integer progressBarColor = this.getResources().getColor(R.color.dk_color_55A8FD);
        ClipDrawable d2 = new ClipDrawable((Drawable)new ColorDrawable(progressBarColor.intValue()), 3, 1);
        this.mProgressBar.setProgressDrawable((Drawable)d2);
        this.mProgressBar.setVisibility(8);
        this.addView((View)this.mProgressBar);
    }

    public void showLoadProgress(int progress) {
        if (null != this.mProgressBar) {
            if (this.mProgressBar.getVisibility() == 8) {
                this.mProgressBar.setVisibility(0);
            }
            this.mProgressBar.setProgress(progress);
        }
    }

    public void hideLoadProgress() {
        if (null != this.mProgressBar) {
            this.mProgressBar.setVisibility(8);
        }
    }

    public void loadUrl(String url) {
        if (!(TextUtils.isEmpty((CharSequence)url) || url.startsWith("http://") || url.startsWith("https://") || url.startsWith("javascript:"))) {
            url = "http://" + url;
        }
        super.loadUrl(url);
    }

    public Activity getActivity() {
        return this.mContainerActivity;
    }
}

