/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.tableview.style;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PathEffect;
import com.didichuxing.doraemonkit.widget.tableview.intface.IStyle;
import com.didichuxing.doraemonkit.widget.tableview.utils.DensityUtils;

public class LineStyle
implements IStyle {
    private float width = -1.0f;
    private int color = -1;
    private boolean isFill;
    private PathEffect effect = new PathEffect();
    private static float defaultLineSize = 2.0f;
    private static int defaultLineColor = Color.parseColor((String)"#e6e6e6");

    public LineStyle() {
    }

    public LineStyle(float width, int color2) {
        this.width = width;
        this.color = color2;
    }

    public LineStyle(Context context, float dp, int color2) {
        this.width = DensityUtils.dp2px(context, dp);
        this.color = color2;
    }

    public static void setDefaultLineSize(float width) {
        defaultLineSize = width;
    }

    public static void setDefaultLineSize(Context context, float dp) {
        defaultLineSize = DensityUtils.dp2px(context, dp);
    }

    public static void setDefaultLineColor(int color2) {
        defaultLineColor = color2;
    }

    public float getWidth() {
        if (this.width == -1.0f) {
            return defaultLineSize;
        }
        return this.width;
    }

    public LineStyle setWidth(float width) {
        this.width = width;
        return this;
    }

    public LineStyle setWidth(Context context, int dp) {
        this.width = DensityUtils.dp2px(context, dp);
        return this;
    }

    public int getColor() {
        if (this.color == -1) {
            return defaultLineColor;
        }
        return this.color;
    }

    public boolean isFill() {
        return this.isFill;
    }

    public LineStyle setFill(boolean fill) {
        this.isFill = fill;
        return this;
    }

    public LineStyle setColor(int color2) {
        this.color = color2;
        return this;
    }

    public LineStyle setEffect(PathEffect effect) {
        this.effect = effect;
        return this;
    }

    @Override
    public void fillPaint(Paint paint) {
        paint.setColor(this.getColor());
        paint.setStyle(this.isFill ? Paint.Style.FILL : Paint.Style.STROKE);
        paint.setStrokeWidth(this.getWidth());
        paint.setPathEffect(this.effect);
    }
}

