/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.tableview.bean;

import com.didichuxing.doraemonkit.widget.tableview.TableConfig;
import com.didichuxing.doraemonkit.widget.tableview.bean.Column;
import com.didichuxing.doraemonkit.widget.tableview.bean.TableData;
import com.didichuxing.doraemonkit.widget.tableview.intface.IDrawFormat;
import com.didichuxing.doraemonkit.widget.tableview.intface.IFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ArrayTableData<T>
extends TableData<T> {
    private T[][] data;
    private List<Column<T>> arrayColumns;

    public static <T> ArrayTableData<T> create(String tableName, String[] titleNames, T[][] data, IDrawFormat<T> drawFormat) {
        ArrayList<Column<T>> columns = new ArrayList<Column<T>>();
        for (int i = 0; i < data.length; ++i) {
            T[] dataArray = data[i];
            Column<T> column = new Column<T>(titleNames == null ? "" : titleNames[i], null, drawFormat);
            column.setDatas(Arrays.asList(dataArray));
            columns.add(column);
        }
        ArrayList<T> arrayList = new ArrayList<T>(Arrays.asList(data[0]));
        ArrayTableData<T> tableData = new ArrayTableData<T>(tableName, arrayList, columns);
        tableData.setData(data);
        return tableData;
    }

    public static <T> ArrayTableData<T> create(String tableName, T[][] data, IDrawFormat<T> drawFormat) {
        TableConfig.getInstance().setShowColumnTitle(false);
        return ArrayTableData.create(tableName, null, data, drawFormat);
    }

    public void setFormat(IFormat<T> format) {
        for (Column<T> column : this.arrayColumns) {
            column.setFormat(format);
        }
    }

    public void setDrawFormat(IDrawFormat<T> format) {
        for (Column<T> column : this.arrayColumns) {
            column.setDrawFormat(format);
        }
    }

    public void setMinWidth(int minWidth) {
        for (Column<T> column : this.arrayColumns) {
            column.setMinWidth(minWidth);
        }
    }

    public void setMinHeight(int minHeight) {
        for (Column<T> column : this.arrayColumns) {
            column.setMinHeight(minHeight);
        }
    }

    protected ArrayTableData(String tableName, List<T> t, List<Column<T>> columns) {
        super(tableName, t, new ArrayList<Column>(columns));
        this.arrayColumns = columns;
    }

    public List<Column<T>> getArrayColumns() {
        return this.arrayColumns;
    }

    public T[][] getData() {
        return this.data;
    }

    public void setData(T[][] data) {
        this.data = data;
    }
}

