/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.dropdown;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.widget.dropdown.Orientation;
import java.util.ArrayList;
import java.util.List;

public class DkDropDownMenu
extends LinearLayout {
    private static final String TAG = "DkDropDownMenu";
    List<View> dropTabViews = new ArrayList<View>();
    private LinearLayout tabMenuView;
    private FrameLayout containerView;
    private FrameLayout popupMenuViews;
    private View maskView;
    private int current_tab_position = -1;
    private float dividerHeight;
    private int dividerColor = -3355444;
    private int textSelectedColor = -7795579;
    private int textUnselectedColor = -15658735;
    private int maskColor = -2004318072;
    private int menuTextSize = 14;
    private static int iconOrientation = 2;
    private Orientation mOrientation;
    private int menuSelectedIcon;
    private int menuUnselectedIcon;
    OnItemMenuClickListener itemMenuClickListener;

    public DkDropDownMenu(Context context) {
        super(context, null);
    }

    public DkDropDownMenu(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DkDropDownMenu(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        int menuBackgroundColor = -1;
        int underlineColor = -3355444;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DkDropDownMenu);
        underlineColor = a.getColor(R.styleable.DkDropDownMenu_dk_ddunderlineColor, underlineColor);
        this.dividerColor = a.getColor(R.styleable.DkDropDownMenu_dk_dddividerColor, this.dividerColor);
        this.textSelectedColor = a.getColor(R.styleable.DkDropDownMenu_dk_ddtextSelectedColor, this.textSelectedColor);
        this.textUnselectedColor = a.getColor(R.styleable.DkDropDownMenu_dk_ddtextUnselectedColor, this.textUnselectedColor);
        menuBackgroundColor = a.getColor(R.styleable.DkDropDownMenu_dk_ddmenuBackgroundColor, menuBackgroundColor);
        this.maskColor = a.getColor(R.styleable.DkDropDownMenu_dk_ddmaskColor, this.maskColor);
        this.menuTextSize = a.getDimensionPixelSize(R.styleable.DkDropDownMenu_dk_ddmenuTextSize, this.menuTextSize);
        this.dividerHeight = a.getDimensionPixelSize(R.styleable.DkDropDownMenu_dk_dddividerHeight, -1);
        this.menuSelectedIcon = a.getResourceId(R.styleable.DkDropDownMenu_dk_ddmenuSelectedIcon, this.menuSelectedIcon);
        this.menuUnselectedIcon = a.getResourceId(R.styleable.DkDropDownMenu_dk_ddmenuUnselectedIcon, this.menuUnselectedIcon);
        iconOrientation = a.getInt(R.styleable.DkDropDownMenu_dk_ddmenuIconOrientation, iconOrientation);
        a.recycle();
        this.mOrientation = new Orientation(this.getContext());
        this.mOrientation.init(iconOrientation, this.menuSelectedIcon, this.menuUnselectedIcon);
        this.tabMenuView = new LinearLayout(context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        this.tabMenuView.setOrientation(0);
        this.tabMenuView.setBackgroundColor(menuBackgroundColor);
        this.tabMenuView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView((View)this.tabMenuView, 0);
        View underLine = new View(this.getContext());
        underLine.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, this.dpTpPx(1.0f)));
        underLine.setBackgroundColor(underlineColor);
        this.addView(underLine, 1);
        this.containerView = new FrameLayout(context);
        this.containerView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.containerView, 2);
    }

    public void setDropDownMenu(@NonNull List<String> tabTexts, @NonNull List<View> popupViews, @NonNull View contentView) {
        int i;
        if (tabTexts.size() != popupViews.size()) {
            throw new IllegalArgumentException("params not match, tabTexts.size() should be equal popupViews.size()");
        }
        for (i = 0; i < tabTexts.size(); ++i) {
            this.addTab(tabTexts, i);
        }
        this.containerView.addView(contentView, 0);
        this.maskView = new View(this.getContext());
        this.maskView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.maskView.setBackgroundColor(this.maskColor);
        this.maskView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DkDropDownMenu.this.closeMenu();
            }
        });
        this.containerView.addView(this.maskView, 1);
        this.maskView.setVisibility(8);
        this.popupMenuViews = new FrameLayout(this.getContext());
        this.popupMenuViews.setVisibility(8);
        this.containerView.addView((View)this.popupMenuViews, 2);
        for (i = 0; i < popupViews.size(); ++i) {
            if (popupViews.get(i).getLayoutParams() == null) {
                popupViews.get(i).setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
            }
            this.popupMenuViews.addView(popupViews.get(i), i);
        }
    }

    public void addTab(View tab, int index) {
        if (index == (this.tabMenuView.getChildCount() + 1) / 2) {
            this.addTabEnd(tab);
            return;
        }
        this.tabMenuView.addView(tab, index * 2);
        this.tabMenuView.addView(this.getDividerView(), index * 2 + 1);
    }

    public void addTabEnd(View tab) {
        this.tabMenuView.addView(this.getDividerView(), this.tabMenuView.getChildCount());
        this.tabMenuView.addView(tab, this.tabMenuView.getChildCount());
    }

    private void addTab(@NonNull List<String> tabTexts, final int i) {
        View tab = DkDropDownMenu.inflate((Context)this.getContext(), (int)R.layout.dk_dropdownmenu_tab_item, null);
        tab.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        final TextView textView = this.getTabTextView(tab);
        textView.setText((CharSequence)tabTexts.get(i));
        textView.setTextColor(this.textUnselectedColor);
        textView.setTextSize(0, (float)this.menuTextSize);
        this.setTextDrawables(textView, true);
        this.tabMenuView.addView(tab);
        tab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DkDropDownMenu.this.itemMenuClickListener != null) {
                    DkDropDownMenu.this.itemMenuClickListener.OnItemMenuClick(textView, i);
                }
                DkDropDownMenu.this.switchMenu(v);
            }
        });
        if (i < tabTexts.size() - 1) {
            this.tabMenuView.addView(this.getDividerView());
        }
        this.dropTabViews.add(tab);
    }

    private View getDividerView() {
        View view = new View(this.getContext());
        double height = this.dividerHeight > 0.0f ? (double)this.dpTpPx(this.dividerHeight) : (double)this.dividerHeight;
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.dpTpPx(0.5f), (int)height);
        params.gravity = 16;
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        view.setBackgroundColor(this.dividerColor);
        return view;
    }

    private TextView getTabTextView(View tabView) {
        TextView tabtext = (TextView)tabView.findViewById(R.id.tv_tab);
        return tabtext;
    }

    public void setTabText(String text) {
        if (this.current_tab_position != -1) {
            this.getTabTextView(this.tabMenuView.getChildAt(this.current_tab_position)).setText((CharSequence)text);
        }
    }

    public void resetTabText(String[] tabs) {
        for (int index = 0; index < tabs.length; ++index) {
            int tvIndex = index == 0 ? 0 : index + 1;
            TextView tv = this.getTabTextView(this.tabMenuView.getChildAt(tvIndex));
            if (tv == null) continue;
            tv.setText((CharSequence)tabs[index]);
        }
    }

    public void setTabClickable(boolean clickable) {
        for (int i = 0; i < this.tabMenuView.getChildCount(); i += 2) {
            this.tabMenuView.getChildAt(i).setClickable(clickable);
        }
    }

    public void closeMenu() {
        if (this.current_tab_position != -1) {
            TextView textView = this.getTabTextView(this.tabMenuView.getChildAt(this.current_tab_position));
            textView.setTextColor(this.textUnselectedColor);
            this.setTextDrawables(textView, true);
            this.popupMenuViews.setVisibility(8);
            this.popupMenuViews.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.dk_dd_menu_out));
            this.maskView.setVisibility(8);
            this.maskView.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.dk_dd_mask_out));
            this.current_tab_position = -1;
        }
    }

    public boolean isActive() {
        return this.current_tab_position != -1;
    }

    public void setTextDrawables(TextView textview, boolean close) {
        textview.setCompoundDrawablesWithIntrinsicBounds(this.mOrientation.getLeft(close), this.mOrientation.getTop(close), this.mOrientation.getRight(close), this.mOrientation.getBottom(close));
    }

    public boolean isShowing() {
        return this.current_tab_position != -1;
    }

    private void switchMenu(View target) {
        for (int i = 0; i < this.tabMenuView.getChildCount(); i += 2) {
            View listView;
            if (target == this.tabMenuView.getChildAt(i)) {
                View listView2;
                if (this.current_tab_position == i) {
                    this.closeMenu();
                    continue;
                }
                if (this.current_tab_position == -1) {
                    this.popupMenuViews.setVisibility(0);
                    this.popupMenuViews.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.dk_dd_menu_in));
                    this.maskView.setVisibility(0);
                    this.maskView.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.dk_dd_mask_in));
                }
                if ((listView2 = this.getListView(this.tabMenuView.getChildAt(i))) != null) {
                    listView2.setVisibility(0);
                }
                this.current_tab_position = i;
                TextView textView = this.getTabTextView(this.tabMenuView.getChildAt(i));
                textView.setTextColor(this.textSelectedColor);
                this.setTextDrawables(textView, false);
                continue;
            }
            TextView textView = this.getTabTextView(this.tabMenuView.getChildAt(i));
            if (textView != null) {
                textView.setTextColor(this.textUnselectedColor);
            }
            if ((listView = this.getListView(this.tabMenuView.getChildAt(i))) == null) continue;
            if (textView != null) {
                this.setTextDrawables(textView, true);
            }
            listView.setVisibility(8);
        }
    }

    public void setOnItemMenuClickListener(OnItemMenuClickListener listener) {
        this.itemMenuClickListener = listener;
    }

    private View getListView(View view) {
        if (this.dropTabViews.contains(view)) {
            int index = this.dropTabViews.indexOf(view);
            return this.popupMenuViews.getChildAt(index);
        }
        return null;
    }

    public int dpTpPx(float value) {
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        return (int)((double)TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)dm) + 0.5);
    }

    public static interface OnItemMenuClickListener {
        public void OnItemMenuClick(TextView var1, int var2);
    }
}

