/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.annotation.AnyRes;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.layoutborder.ViewBorderFrameLayout;
import com.didichuxing.doraemonkit.util.ConvertUtils;
import com.didichuxing.doraemonkit.util.LogHelper;
import com.didichuxing.doraemonkit.util.ScreenUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;

public class UIUtils {
    private static final String TAG = "UIUtils";
    private static final String STR_VIEW_BORDER_Id = "app:id/dokit_view_border_id";

    public static int dp2px(float dpValue) {
        return ConvertUtils.dp2px((float)dpValue);
    }

    public static int px2dp(int px) {
        return ConvertUtils.px2dp((float)px);
    }

    public static float getDensity() {
        return ScreenUtils.getScreenDensity();
    }

    public static int getDensityDpi() {
        return ScreenUtils.getScreenDensityDpi();
    }

    public static int getWidthPixels() {
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)DoKit.APPLICATION.getSystemService("window");
        if (windowManager == null) {
            return 0;
        }
        windowManager.getDefaultDisplay().getMetrics(metrics);
        return metrics.widthPixels;
    }

    public static int getHeightPixels() {
        return UIUtils.getRealHeightPixels() - UIUtils.getStatusBarHeight();
    }

    public static int getRealHeightPixels() {
        WindowManager windowManager = (WindowManager)DoKit.APPLICATION.getSystemService("window");
        int height = 0;
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        try {
            Class<?> c = Class.forName("android.view.Display");
            Method method = c.getMethod("getRealMetrics", DisplayMetrics.class);
            method.invoke((Object)display, dm);
            height = dm.heightPixels;
        }
        catch (Exception e) {
            LogHelper.d(TAG, e.toString());
        }
        return height;
    }

    public static int getStatusBarHeight() {
        Resources resources = DoKit.APPLICATION.getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        int height = resources.getDimensionPixelSize(resourceId);
        return height;
    }

    public static Rect getViewRect(View view) {
        Rect rect = new Rect();
        int[] locations = new int[2];
        view.getLocationOnScreen(locations);
        rect.left = locations[0];
        rect.top = locations[1];
        if (!UIUtils.checkStatusBarVisible(view.getContext())) {
            rect.top -= UIUtils.getStatusBarHeight();
        }
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        return rect;
    }

    public static boolean checkStatusBarVisible(Context context) {
        return UIUtils.checkFullScreenByTheme(context) || UIUtils.checkFullScreenByCode(context) || UIUtils.checkFullScreenByCode2(context);
    }

    public static boolean checkFullScreenByTheme(Context context) {
        TypedValue typedValue;
        boolean result2;
        Resources.Theme theme = context.getTheme();
        if (theme != null && (result2 = theme.resolveAttribute(16843277, typedValue = new TypedValue(), false))) {
            typedValue.coerceToString();
            if (typedValue.type == 18) {
                return typedValue.data != 0;
            }
        }
        return false;
    }

    public static boolean checkFullScreenByCode(Context context) {
        View decorView;
        Window window;
        if (context instanceof Activity && (window = ((Activity)context).getWindow()) != null && (decorView = window.getDecorView()) != null) {
            return (decorView.getSystemUiVisibility() & 4) == 4;
        }
        return false;
    }

    public static boolean checkFullScreenByCode2(Context context) {
        if (context instanceof Activity) {
            return (((Activity)context).getWindow().getAttributes().flags & 0x400) == 1024;
        }
        return false;
    }

    public static String getIdText(View view) {
        int id2 = view.getId();
        StringBuilder out = new StringBuilder();
        if (id2 != -1) {
            Resources r = view.getResources();
            if (id2 > 0 && UIUtils.resourceHasPackage(id2) && r != null) {
                try {
                    String pkgname;
                    switch (id2 & 0xFF000000) {
                        case 0x7F000000: {
                            pkgname = "app";
                            break;
                        }
                        case 0x1000000: {
                            pkgname = "android";
                            break;
                        }
                        default: {
                            pkgname = r.getResourcePackageName(id2);
                        }
                    }
                    String typename = r.getResourceTypeName(id2);
                    String entryname = r.getResourceEntryName(id2);
                    out.append(" ");
                    out.append(pkgname);
                    out.append(":");
                    out.append(typename);
                    out.append("/");
                    out.append(entryname);
                }
                catch (Resources.NotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return TextUtils.isEmpty((CharSequence)out.toString()) ? "" : out.toString();
    }

    public static String getRealIdText(View view) {
        String id2 = UIUtils.getIdText(view);
        if (id2.isEmpty()) {
            return "-1";
        }
        return id2.split("/")[1];
    }

    public static View getDokitAppContentView(Activity activity) {
        FrameLayout decorView = (FrameLayout)activity.getWindow().getDecorView();
        View mAppContentView = (View)decorView.getTag(R.id.dokit_app_contentview_id);
        if (mAppContentView != null) {
            return mAppContentView;
        }
        for (int index = 0; index < decorView.getChildCount(); ++index) {
            View child = decorView.getChildAt(index);
            if ((!(child instanceof LinearLayout) || !TextUtils.isEmpty((CharSequence)UIUtils.getIdText(child).trim())) && !(child instanceof FrameLayout)) continue;
            mAppContentView = UIUtils.getIdText(child).trim().equals(STR_VIEW_BORDER_Id) ? ((ViewBorderFrameLayout)child).getChildAt(0) : child;
            mAppContentView.setTag((Object)R.id.dokit_app_contentview_id);
            break;
        }
        return mAppContentView;
    }

    private static boolean resourceHasPackage(@AnyRes int resid) {
        return resid >>> 24 != 0;
    }

    public static double getScreenInch(Activity context) {
        double inch = 0.0;
        try {
            int realWidth = 0;
            int realHeight = 0;
            Display display = context.getWindowManager().getDefaultDisplay();
            DisplayMetrics metrics = new DisplayMetrics();
            display.getMetrics(metrics);
            if (Build.VERSION.SDK_INT >= 17) {
                Point size = new Point();
                display.getRealSize(size);
                realWidth = size.x;
                realHeight = size.y;
            } else if (Build.VERSION.SDK_INT < 17 && Build.VERSION.SDK_INT >= 14) {
                Method mGetRawH = Display.class.getMethod("getRawHeight", new Class[0]);
                Method mGetRawW = Display.class.getMethod("getRawWidth", new Class[0]);
                realWidth = (Integer)mGetRawW.invoke((Object)display, new Object[0]);
                realHeight = (Integer)mGetRawH.invoke((Object)display, new Object[0]);
            } else {
                realWidth = metrics.widthPixels;
                realHeight = metrics.heightPixels;
            }
            inch = UIUtils.formatDouble(Math.sqrt((float)realWidth / metrics.xdpi * ((float)realWidth / metrics.xdpi) + (float)realHeight / metrics.ydpi * ((float)realHeight / metrics.ydpi)), 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inch;
    }

    private static double formatDouble(double d2, int newScale) {
        BigDecimal bd = new BigDecimal(d2);
        return bd.setScale(newScale, 4).doubleValue();
    }
}

