/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class Reflector {
    public static final String TAG = "Reflector";
    protected Class<?> mType;
    protected Object mCaller;
    protected Constructor mConstructor;
    protected Field mField;
    protected Method mMethod;

    public static Reflector on(@NonNull String name) throws ReflectedException {
        return Reflector.on(name, true, Reflector.class.getClassLoader());
    }

    public static Reflector on(@NonNull String name, boolean initialize) throws ReflectedException {
        return Reflector.on(name, initialize, Reflector.class.getClassLoader());
    }

    public static Reflector on(@NonNull String name, boolean initialize, @Nullable ClassLoader loader) throws ReflectedException {
        try {
            return Reflector.on(Class.forName(name, initialize, loader));
        }
        catch (Throwable e) {
            throw new ReflectedException("Oops!", e);
        }
    }

    public static Reflector on(@NonNull Class<?> type) {
        Reflector reflector = new Reflector();
        reflector.mType = type;
        return reflector;
    }

    public static Reflector with(@NonNull Object caller) throws ReflectedException {
        return Reflector.on(caller.getClass()).bind(caller);
    }

    protected Reflector() {
    }

    public Reflector constructor(Class<?> ... parameterTypes) throws ReflectedException {
        try {
            this.mConstructor = this.mType.getDeclaredConstructor(parameterTypes);
            this.mConstructor.setAccessible(true);
            this.mField = null;
            this.mMethod = null;
            return this;
        }
        catch (Throwable e) {
            throw new ReflectedException("Oops!", e);
        }
    }

    public <R> R newInstance(Object ... initargs) throws ReflectedException {
        if (this.mConstructor == null) {
            throw new ReflectedException("Constructor was null!");
        }
        try {
            return (R)this.mConstructor.newInstance(initargs);
        }
        catch (InvocationTargetException e) {
            throw new ReflectedException("Oops!", e.getTargetException());
        }
        catch (Throwable e) {
            throw new ReflectedException("Oops!", e);
        }
    }

    protected Object checked(@Nullable Object caller) throws ReflectedException {
        if (caller == null || this.mType.isInstance(caller)) {
            return caller;
        }
        throw new ReflectedException("Caller [" + caller + "] is not a instance of type [" + this.mType + "]!");
    }

    protected void check(@Nullable Object caller, @Nullable Member member, @NonNull String name) throws ReflectedException {
        if (member == null) {
            throw new ReflectedException(name + " was null!");
        }
        if (caller == null && !Modifier.isStatic(member.getModifiers())) {
            throw new ReflectedException("Need a caller!");
        }
        this.checked(caller);
    }

    public Reflector bind(@Nullable Object caller) throws ReflectedException {
        this.mCaller = this.checked(caller);
        return this;
    }

    public Reflector unbind() {
        this.mCaller = null;
        return this;
    }

    public Reflector field(@NonNull String name) throws ReflectedException {
        try {
            this.mField = this.findField(name);
            this.mField.setAccessible(true);
            this.mConstructor = null;
            this.mMethod = null;
            return this;
        }
        catch (Throwable e) {
            throw new ReflectedException("Oops!", e);
        }
    }

    protected Field findField(@NonNull String name) throws NoSuchFieldException {
        try {
            return this.mType.getField(name);
        }
        catch (NoSuchFieldException e) {
            for (Class<?> cls = this.mType; cls != null; cls = cls.getSuperclass()) {
                try {
                    return cls.getDeclaredField(name);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
            throw e;
        }
    }

    public <R> R get() throws ReflectedException {
        return this.get(this.mCaller);
    }

    public <R> R get(@Nullable Object caller) throws ReflectedException {
        this.check(caller, this.mField, "Field");
        try {
            return (R)this.mField.get(caller);
        }
        catch (Throwable e) {
            throw new ReflectedException("Oops!", e);
        }
    }

    public Reflector set(@Nullable Object value) throws ReflectedException {
        return this.set(this.mCaller, value);
    }

    public Reflector set(@Nullable Object caller, @Nullable Object value) throws ReflectedException {
        this.check(caller, this.mField, "Field");
        try {
            this.mField.set(caller, value);
            return this;
        }
        catch (Throwable e) {
            throw new ReflectedException("Oops!", e);
        }
    }

    public Reflector method(@NonNull String name, Class<?> ... parameterTypes) throws ReflectedException {
        try {
            this.mMethod = this.findMethod(name, parameterTypes);
            this.mMethod.setAccessible(true);
            this.mConstructor = null;
            this.mField = null;
            return this;
        }
        catch (NoSuchMethodException e) {
            throw new ReflectedException("Oops!", e);
        }
    }

    protected Method findMethod(@NonNull String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        try {
            return this.mType.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            for (Class<?> cls = this.mType; cls != null; cls = cls.getSuperclass()) {
                try {
                    return cls.getDeclaredMethod(name, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            throw e;
        }
    }

    public <R> R call(Object ... args) throws ReflectedException {
        return this.callByCaller(this.mCaller, args);
    }

    public <R> R callByCaller(@Nullable Object caller, Object ... args) throws ReflectedException {
        this.check(caller, this.mMethod, "Method");
        try {
            return (R)this.mMethod.invoke(caller, args);
        }
        catch (InvocationTargetException e) {
            throw new ReflectedException("Oops!", e.getTargetException());
        }
        catch (Throwable e) {
            throw new ReflectedException("Oops!", e);
        }
    }

    public static class QuietReflector
    extends Reflector {
        protected Throwable mIgnored;

        public static QuietReflector on(@NonNull String name) {
            return QuietReflector.on(name, true, QuietReflector.class.getClassLoader());
        }

        public static QuietReflector on(@NonNull String name, boolean initialize) {
            return QuietReflector.on(name, initialize, QuietReflector.class.getClassLoader());
        }

        public static QuietReflector on(@NonNull String name, boolean initialize, @Nullable ClassLoader loader) {
            Class<?> cls = null;
            try {
                cls = Class.forName(name, initialize, loader);
                return QuietReflector.on(cls, null);
            }
            catch (Throwable e) {
                return QuietReflector.on(cls, e);
            }
        }

        public static QuietReflector on(@Nullable Class<?> type) {
            return QuietReflector.on(type, type == null ? new ReflectedException("Type was null!") : null);
        }

        private static QuietReflector on(@Nullable Class<?> type, @Nullable Throwable ignored) {
            QuietReflector reflector = new QuietReflector();
            reflector.mType = type;
            reflector.mIgnored = ignored;
            return reflector;
        }

        public static QuietReflector with(@Nullable Object caller) {
            if (caller == null) {
                return QuietReflector.on((Class)null);
            }
            return QuietReflector.on(caller.getClass()).bind(caller);
        }

        protected QuietReflector() {
        }

        public Throwable getIgnored() {
            return this.mIgnored;
        }

        protected boolean skip() {
            return this.skipAlways() || this.mIgnored != null;
        }

        protected boolean skipAlways() {
            return this.mType == null;
        }

        @Override
        public QuietReflector constructor(Class<?> ... parameterTypes) {
            if (this.skipAlways()) {
                return this;
            }
            try {
                this.mIgnored = null;
                super.constructor(parameterTypes);
            }
            catch (Throwable e) {
                this.mIgnored = e;
            }
            return this;
        }

        @Override
        public <R> R newInstance(Object ... initargs) {
            if (this.skip()) {
                return null;
            }
            try {
                this.mIgnored = null;
                return super.newInstance(initargs);
            }
            catch (Throwable e) {
                this.mIgnored = e;
                return null;
            }
        }

        @Override
        public QuietReflector bind(@Nullable Object obj) {
            if (this.skipAlways()) {
                return this;
            }
            try {
                this.mIgnored = null;
                super.bind(obj);
            }
            catch (Throwable e) {
                this.mIgnored = e;
            }
            return this;
        }

        @Override
        public QuietReflector unbind() {
            super.unbind();
            return this;
        }

        @Override
        public QuietReflector field(@NonNull String name) {
            if (this.skipAlways()) {
                return this;
            }
            try {
                this.mIgnored = null;
                super.field(name);
            }
            catch (Throwable e) {
                this.mIgnored = e;
            }
            return this;
        }

        @Override
        public <R> R get() {
            if (this.skip()) {
                return null;
            }
            try {
                this.mIgnored = null;
                return super.get();
            }
            catch (Throwable e) {
                this.mIgnored = e;
                return null;
            }
        }

        @Override
        public <R> R get(@Nullable Object caller) {
            if (this.skip()) {
                return null;
            }
            try {
                this.mIgnored = null;
                return super.get(caller);
            }
            catch (Throwable e) {
                this.mIgnored = e;
                return null;
            }
        }

        @Override
        public QuietReflector set(@Nullable Object value) {
            if (this.skip()) {
                return this;
            }
            try {
                this.mIgnored = null;
                super.set(value);
            }
            catch (Throwable e) {
                this.mIgnored = e;
            }
            return this;
        }

        @Override
        public QuietReflector set(@Nullable Object caller, @Nullable Object value) {
            if (this.skip()) {
                return this;
            }
            try {
                this.mIgnored = null;
                super.set(caller, value);
            }
            catch (Throwable e) {
                this.mIgnored = e;
            }
            return this;
        }

        @Override
        public QuietReflector method(@NonNull String name, Class<?> ... parameterTypes) {
            if (this.skipAlways()) {
                return this;
            }
            try {
                this.mIgnored = null;
                super.method(name, parameterTypes);
            }
            catch (Throwable e) {
                this.mIgnored = e;
            }
            return this;
        }

        @Override
        public <R> R call(Object ... args) {
            if (this.skip()) {
                return null;
            }
            try {
                this.mIgnored = null;
                return super.call(args);
            }
            catch (Throwable e) {
                this.mIgnored = e;
                return null;
            }
        }

        @Override
        public <R> R callByCaller(@Nullable Object caller, Object ... args) {
            if (this.skip()) {
                return null;
            }
            try {
                this.mIgnored = null;
                return super.callByCaller(caller, args);
            }
            catch (Throwable e) {
                this.mIgnored = e;
                return null;
            }
        }
    }

    public static class ReflectedException
    extends Exception {
        public ReflectedException(String message) {
            super(message);
        }

        public ReflectedException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

