/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import com.didichuxing.doraemonkit.kit.core.ActivityLifecycleStatusInfo;
import com.didichuxing.doraemonkit.kit.core.DoKitManager;
import com.didichuxing.doraemonkit.util.LogHelper;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DoKitSystemUtil {
    private static final String TAG = "SystemUtil";
    private static final Pattern VERSION_NAME_PATTERN = Pattern.compile("(\\d+\\.\\d+\\.\\d+)-*.*");
    private static String sAppVersion;
    private static int sAppVersionCode;
    private static String sPackageName;
    private static String sAppName;
    public static final String PHONE_XIAOMI = "xiaomi";
    public static final String PHONE_HUAWEI = "HUAWEI";
    public static final String PHONE_HONOR = "HONOR";
    public static final String PHONE_MEIZU = "Meizu";
    public static final String PHONE_SONY = "sony";
    public static final String PHONE_SAMSUNG = "samsung";
    public static final String PHONE_LG = "lg";
    public static final String PHONE_HTC = "htc";
    public static final String PHONE_NOVA = "nova";
    public static final String PHONE_OPPO = "oppo";
    public static final String PHONE_VIVO = "vivo";
    public static final String PHONE_LeMobile = "LeMobile";
    public static final String PHONE_LENOVO = "lenovo";

    public static String getVersionName(Context context) {
        if (!TextUtils.isEmpty((CharSequence)sAppVersion)) {
            return sAppVersion;
        }
        String appVersion = "";
        try {
            Matcher matcher;
            String pkgName = context.getApplicationInfo().packageName;
            appVersion = context.getPackageManager().getPackageInfo((String)pkgName, (int)0).versionName;
            if (appVersion != null && appVersion.length() > 0 && (matcher = VERSION_NAME_PATTERN.matcher(appVersion)).matches()) {
                sAppVersion = appVersion = matcher.group(1);
            }
        }
        catch (Throwable t) {
            LogHelper.e(TAG, t.toString());
        }
        return appVersion;
    }

    public static int getVersionCode(Context context) {
        if (sAppVersionCode != -1) {
            return sAppVersionCode;
        }
        try {
            String pkgName = context.getApplicationInfo().packageName;
            int versionCode = context.getPackageManager().getPackageInfo((String)pkgName, (int)0).versionCode;
            if (versionCode != -1) {
                sAppVersionCode = versionCode;
            }
        }
        catch (Throwable t) {
            LogHelper.e(TAG, t.toString());
        }
        return sAppVersionCode;
    }

    public static String getPackageName(Context context) {
        if (TextUtils.isEmpty((CharSequence)sPackageName)) {
            sPackageName = context.getPackageName();
        }
        return sPackageName;
    }

    public static String getAppName(Context context) {
        if (!TextUtils.isEmpty((CharSequence)sAppName)) {
            return sAppName;
        }
        PackageManager packageManager = null;
        ApplicationInfo applicationInfo = null;
        packageManager = context.getPackageManager();
        try {
            applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            LogHelper.e(TAG, e.toString());
        }
        sAppName = (String)packageManager.getApplicationLabel(applicationInfo);
        return sAppName;
    }

    public static String obtainProcessName(Context context) {
        int pid = Process.myPid();
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List listTaskInfo = am.getRunningAppProcesses();
        if (listTaskInfo != null && !listTaskInfo.isEmpty()) {
            for (ActivityManager.RunningAppProcessInfo info : listTaskInfo) {
                if (info == null || info.pid != pid) continue;
                return info.processName;
            }
        }
        return null;
    }

    public static boolean isMainLaunchActivity(Activity activity) {
        PackageManager packageManager = activity.getApplication().getPackageManager();
        Intent intent = packageManager.getLaunchIntentForPackage(activity.getPackageName());
        if (intent == null) {
            return false;
        }
        ComponentName launchComponentName = intent.getComponent();
        ComponentName componentName = activity.getComponentName();
        return launchComponentName != null && componentName.toString().equals(launchComponentName.toString());
    }

    public static boolean isOnlyFirstLaunchActivity(Activity activity) {
        boolean isMainActivity = DoKitSystemUtil.isMainLaunchActivity(activity);
        ActivityLifecycleStatusInfo activityLifecycleInfo = DoKitManager.INSTANCE.getACTIVITY_LIFECYCLE_INFOS().get(activity.getClass().getCanonicalName());
        return activityLifecycleInfo != null && isMainActivity && activityLifecycleInfo.isInvokeStopMethod() == false;
    }

    public static void startDevelopmentActivity(Context context) {
        try {
            Intent intent = new Intent("android.settings.APPLICATION_DEVELOPMENT_SETTINGS");
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (Exception e) {
            try {
                ComponentName componentName = new ComponentName("com.android.settings", "com.android.settings.DevelopmentSettings");
                Intent intent = new Intent();
                intent.setFlags(0x10000000);
                intent.setComponent(componentName);
                intent.setAction("android.intent.action.View");
                context.startActivity(intent);
            }
            catch (Exception e1) {
                try {
                    Intent intent = new Intent("com.android.settings.APPLICATION_DEVELOPMENT_SETTINGS");
                    intent.setFlags(0x10000000);
                    context.startActivity(intent);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    public static void startLocalActivity(Context context) {
        try {
            Intent intent = new Intent("android.settings.LOCALE_SETTINGS");
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startServiceRunningActivity(Context context) {
        try {
            ComponentName componentName = DoKitSystemUtil.getBrand().equalsIgnoreCase(PHONE_VIVO) ? new ComponentName("com.android.settings", "com.vivo.settings.VivoSubSettingsForImmersiveBar") : new ComponentName("com.android.settings", "com.android.settings.CleanSubSettings");
            Intent intent = new Intent();
            intent.setFlags(0x10000000);
            intent.setComponent(componentName);
            intent.setAction("android.intent.action.View");
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getBrand() {
        return Build.BRAND;
    }

    static {
        sAppVersionCode = -1;
    }
}

