/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import androidx.annotation.StringRes;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.util.LogHelper;
import java.io.IOException;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.json.JSONException;
import org.json.JSONObject;

public class DoKitCommUtil {
    public static String getString(@StringRes int stringId) {
        return DoKit.APPLICATION.getString(stringId);
    }

    @StringRes
    public static int getStringId(String str) {
        try {
            Resources r = DoKit.APPLICATION.getResources();
            return r.getIdentifier(str, "string", DoKit.APPLICATION.getPackageName());
        }
        catch (Exception e) {
            LogHelper.e("getStringId", "getStringId===>" + str);
            return -1;
        }
    }

    public static String requestBodyToString(RequestBody requestBody) {
        try {
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String param2Json(String param) throws JSONException {
        String[] params = param.split("&");
        JSONObject jsonObject = new JSONObject();
        for (String p : params) {
            String[] ps = p.split("=");
            if (ps.length != 2) continue;
            String key = ps[0];
            String value = ps[1];
            jsonObject.put(key, (Object)value);
        }
        return jsonObject.toString();
    }

    public static void changeAppOnForeground(Class<Activity> clazz) {
        Intent intent = new Intent((Context)DoKit.APPLICATION, clazz);
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.setAction("android.intent.action.MAIN");
        intent.setFlags(0x10200000);
        DoKit.APPLICATION.startActivity(intent);
    }
}

