/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.weaknetwork;

import android.os.SystemClock;
import com.didichuxing.doraemonkit.okhttp_api.OkHttpWrap;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Sink;

public class SpeedLimitRequestBody
extends RequestBody {
    private long mSpeedByte;
    private RequestBody mRequestBody;
    private BufferedSink mBufferedSink;

    public SpeedLimitRequestBody(long speed, RequestBody source) {
        this.mRequestBody = source;
        this.mSpeedByte = speed * 1024L;
    }

    public MediaType contentType() {
        return this.mRequestBody.contentType();
    }

    public long contentLength() throws IOException {
        return this.mRequestBody.contentLength();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        if (this.mBufferedSink == null) {
            this.mBufferedSink = OkHttpWrap.INSTANCE.createByteCountBufferedSink(this.sink(sink), 1024L);
        }
        this.mRequestBody.writeTo(this.mBufferedSink);
        this.mBufferedSink.close();
    }

    private Sink sink(BufferedSink sink) {
        return new ForwardingSink((Sink)sink){
            private long cacheTotalBytesWritten;
            private long cacheStartTime;

            public void write(Buffer source, long byteCount) throws IOException {
                if (this.cacheStartTime == 0L) {
                    this.cacheStartTime = SystemClock.uptimeMillis();
                }
                super.write(source, byteCount);
                this.cacheTotalBytesWritten += byteCount;
                long endTime = SystemClock.uptimeMillis() - this.cacheStartTime;
                if (endTime <= 1000L && this.cacheTotalBytesWritten >= SpeedLimitRequestBody.this.mSpeedByte) {
                    long sleep = 1000L - endTime;
                    SystemClock.sleep((long)sleep);
                    this.cacheStartTime = 0L;
                    this.cacheTotalBytesWritten = 0L;
                }
            }
        };
    }
}

