/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.uiperformance;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import com.didichuxing.doraemonkit.model.ViewInfo;
import com.didichuxing.doraemonkit.util.LogHelper;
import com.didichuxing.doraemonkit.util.UIUtils;
import java.util.ArrayList;
import java.util.List;

public class UIPerformanceUtil {
    private static final String TAG = "UIPerformanceUtil";

    public static List<ViewInfo> getViewInfos(Activity activity) {
        if (activity == null) {
            LogHelper.d(TAG, "resume activity is null");
            return new ArrayList<ViewInfo>();
        }
        if (activity.getWindow() == null) {
            LogHelper.d(TAG, "resume activity window is null");
            return new ArrayList<ViewInfo>();
        }
        return UIPerformanceUtil.getViewInfos(UIUtils.getDokitAppContentView(activity));
    }

    private static List<ViewInfo> getViewInfos(View view) {
        ArrayList<ViewInfo> infos = new ArrayList<ViewInfo>();
        UIPerformanceUtil.traverseViews(view, infos, 0);
        return infos;
    }

    private static void traverseViews(View view, List<ViewInfo> infos, int layerNum) {
        if (view == null) {
            return;
        }
        ++layerNum;
        if (view instanceof ViewGroup) {
            int childCount = ((ViewGroup)view).getChildCount();
            if (childCount != 0) {
                for (int index = childCount - 1; index >= 0; --index) {
                    UIPerformanceUtil.traverseViews(((ViewGroup)view).getChildAt(index), infos, layerNum);
                }
            }
        } else {
            long startTime = System.nanoTime();
            long endTime = System.nanoTime();
            float time = (float)((endTime - startTime) / 10000L) / 100.0f;
            ViewInfo viewInfo = new ViewInfo(view);
            viewInfo.drawTime = time;
            viewInfo.layerNum = layerNum;
            infos.add(viewInfo);
        }
    }
}

