/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.uiperformance;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.AbsDokitView;
import com.didichuxing.doraemonkit.kit.core.DokitViewLayoutParams;
import com.didichuxing.doraemonkit.kit.uiperformance.UIPerformanceDisplayDokitView;
import com.didichuxing.doraemonkit.kit.uiperformance.UIPerformanceManager;
import com.didichuxing.doraemonkit.model.ViewInfo;
import com.didichuxing.doraemonkit.widget.textview.LabelTextView;
import java.util.List;

public class UIPerformanceInfoDokitView
extends AbsDokitView
implements UIPerformanceManager.PerformanceDataListener {
    private ImageView mClose;
    private LabelTextView mMaxLevelText;
    private LabelTextView mMaxLevelViewIdText;
    private LabelTextView mTotalTimeText;
    private LabelTextView mMaxTimeText;
    private LabelTextView mMaxTimeViewIdText;

    @Override
    public View onCreateView(Context context, FrameLayout view) {
        return LayoutInflater.from((Context)view.getContext()).inflate(R.layout.dk_float_ui_performance_info, (ViewGroup)view, false);
    }

    @Override
    public void onViewCreated(FrameLayout view) {
        this.mClose = (ImageView)this.findViewById(R.id.close);
        this.mClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DoKit.removeFloating(UIPerformanceDisplayDokitView.class);
                DoKit.removeFloating(UIPerformanceInfoDokitView.class);
                UIPerformanceManager.getInstance().stop();
            }
        });
        this.mMaxLevelText = (LabelTextView)((Object)this.findViewById(R.id.max_level));
        this.mMaxLevelViewIdText = (LabelTextView)((Object)this.findViewById(R.id.max_level_view_id));
        this.mTotalTimeText = (LabelTextView)((Object)this.findViewById(R.id.total_time));
        this.mMaxTimeText = (LabelTextView)((Object)this.findViewById(R.id.max_time));
        this.mMaxTimeViewIdText = (LabelTextView)((Object)this.findViewById(R.id.max_time_view_id));
    }

    @Override
    public void initDokitViewLayoutParams(DokitViewLayoutParams params) {
        params.y = 60;
        params.height = DokitViewLayoutParams.WRAP_CONTENT;
        params.width = DokitViewLayoutParams.WRAP_CONTENT;
    }

    @Override
    public void onCreate(Context context) {
        UIPerformanceManager.getInstance().addListener(this);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        UIPerformanceManager.getInstance().removeListener(this);
    }

    @Override
    public void onRefresh(List<ViewInfo> viewInfos) {
        if (viewInfos == null) {
            return;
        }
        int maxLevel = 0;
        float maxTime = 0.0f;
        float totalTime = 0.0f;
        ViewInfo maxLevelViewInfo = null;
        ViewInfo maxTimeViewInfo = null;
        for (ViewInfo viewInfo : viewInfos) {
            if (viewInfo.layerNum > maxLevel) {
                maxLevel = viewInfo.layerNum;
                maxLevelViewInfo = viewInfo;
            }
            if (viewInfo.drawTime > maxTime) {
                maxTime = viewInfo.drawTime;
                maxTimeViewInfo = viewInfo;
            }
            totalTime += viewInfo.drawTime;
        }
        this.mMaxLevelText.setText(String.valueOf(maxLevel));
        if (maxLevelViewInfo != null && !TextUtils.isEmpty((CharSequence)maxLevelViewInfo.id)) {
            this.mMaxLevelViewIdText.setText(maxLevelViewInfo.id);
        }
        this.mMaxTimeText.setText(maxTime + "ms");
        if (maxTimeViewInfo != null && !TextUtils.isEmpty((CharSequence)maxTimeViewInfo.id)) {
            this.mMaxTimeViewIdText.setText(maxTimeViewInfo.id);
        }
        this.mTotalTimeText.setText(totalTime + "ms");
    }
}

