/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.timecounter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.AbsDokitView;
import com.didichuxing.doraemonkit.kit.core.DokitViewLayoutParams;
import com.didichuxing.doraemonkit.kit.timecounter.TimeCounterManager;
import com.didichuxing.doraemonkit.kit.timecounter.bean.CounterInfo;
import com.didichuxing.doraemonkit.util.UIUtils;

public class TimeCounterDokitView
extends AbsDokitView {
    private TextView tvTitle;
    private TextView tvTotal;
    private TextView tvPause;
    private TextView tvLaunch;
    private TextView tvRender;
    private TextView tvOther;
    private ImageView mClose;

    @Override
    public void onCreate(Context context) {
    }

    @Override
    public View onCreateView(Context context, FrameLayout view) {
        return LayoutInflater.from((Context)context).inflate(R.layout.dk_float_time_counter, null);
    }

    @Override
    public void initDokitViewLayoutParams(DokitViewLayoutParams params) {
        params.width = DokitViewLayoutParams.WRAP_CONTENT;
        params.height = DokitViewLayoutParams.WRAP_CONTENT;
        params.x = UIUtils.dp2px(30.0f);
        params.y = UIUtils.dp2px(30.0f);
    }

    @Override
    public void onViewCreated(FrameLayout view) {
        this.initView();
    }

    private void initView() {
        this.tvTitle = (TextView)this.findViewById(R.id.title);
        this.tvTotal = (TextView)this.findViewById(R.id.total_cost);
        this.tvPause = (TextView)this.findViewById(R.id.pause_cost);
        this.tvLaunch = (TextView)this.findViewById(R.id.launch_cost);
        this.tvRender = (TextView)this.findViewById(R.id.render_cost);
        this.tvOther = (TextView)this.findViewById(R.id.other_cost);
        CounterInfo counterInfo = TimeCounterManager.get().getAppSetupInfo();
        this.showInfo(counterInfo);
        this.mClose = (ImageView)this.findViewById(R.id.close);
        this.mClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TimeCounterManager.get().stop();
            }
        });
    }

    public void showInfo(CounterInfo info) {
        this.tvTitle.setText((CharSequence)info.title);
        this.setTotalCost(info.totalCost);
        if (info.type == 1) {
            this.tvPause.setVisibility(0);
            this.tvLaunch.setVisibility(0);
            this.tvRender.setVisibility(0);
            this.tvOther.setVisibility(0);
            this.tvPause.setText((CharSequence)("Pause Cost: " + info.pauseCost + "ms"));
            this.tvLaunch.setText((CharSequence)("Launch Cost: " + info.launchCost + "ms"));
            this.tvRender.setText((CharSequence)("Render Cost: " + info.renderCost + "ms"));
            this.tvOther.setText((CharSequence)("Other Cost: " + info.otherCost + "ms"));
        } else {
            this.tvPause.setVisibility(8);
            this.tvLaunch.setVisibility(8);
            this.tvRender.setVisibility(8);
            this.tvOther.setVisibility(8);
        }
    }

    private void setTotalCost(long cost) {
        this.tvTotal.setText((CharSequence)("Total Cost: " + cost + "ms"));
        if (cost <= 500L) {
            this.tvTotal.setTextColor(this.getContext().getResources().getColor(R.color.dk_color_48BB31));
        } else if (cost <= 1000L) {
            this.tvTotal.setTextColor(this.getContext().getResources().getColor(R.color.dk_color_FAD337));
        } else {
            this.tvTotal.setTextColor(this.getContext().getResources().getColor(R.color.dk_color_FF0006));
        }
    }

    private void showDetail(CounterInfo info) {
        if (info.type == 0) {
            info.show = false;
        }
        if (info.show) {
            this.tvPause.setVisibility(0);
            this.tvLaunch.setVisibility(0);
            this.tvRender.setVisibility(0);
            this.tvOther.setVisibility(0);
        } else {
            this.tvPause.setVisibility(8);
            this.tvLaunch.setVisibility(8);
            this.tvRender.setVisibility(8);
            this.tvOther.setVisibility(8);
        }
    }

    @Override
    public void onEnterForeground() {
        super.onEnterForeground();
    }

    @Override
    public void onEnterBackground() {
        super.onEnterBackground();
        TimeCounterManager.get().onEnterBackground();
    }
}

