/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.performance;

import android.content.Context;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.performance.PerformanceDokitView;
import com.didichuxing.doraemonkit.kit.performance.PerformanceFragmentCloseListener;
import com.didichuxing.doraemonkit.kit.performance.performanceViewInfo;
import com.didichuxing.doraemonkit.util.ActivityUtils;
import java.util.TreeMap;

public class PerformanceDokitViewManager {
    public static TreeMap<String, performanceViewInfo> singleperformanceViewInfos = new TreeMap();

    public static void open(int performanceType, String title, PerformanceFragmentCloseListener listener) {
        PerformanceDokitViewManager.open(performanceType, title, 1000, listener);
    }

    public static void open(int performanceType, String title, int interval, PerformanceFragmentCloseListener listener) {
        PerformanceDokitView performanceDokitView = DoKit.getDoKitView(ActivityUtils.getTopActivity(), PerformanceDokitView.class);
        if (performanceDokitView == null) {
            DoKit.launchFloating(PerformanceDokitView.class);
            performanceDokitView = DoKit.getDoKitView(ActivityUtils.getTopActivity(), PerformanceDokitView.class);
            performanceDokitView.addItem(performanceType, title, interval);
        } else {
            performanceDokitView.addItem(performanceType, title, interval);
        }
        performanceDokitView.addPerformanceFragmentCloseListener(listener);
        singleperformanceViewInfos.put(title, new performanceViewInfo(performanceType, title, interval));
    }

    public static void onPerformanceSettingFragmentDestroy(PerformanceFragmentCloseListener listener) {
        PerformanceDokitView performanceDokitView = DoKit.getDoKitView(ActivityUtils.getTopActivity(), PerformanceDokitView.class);
        if (performanceDokitView != null) {
            performanceDokitView.removePerformanceFragmentCloseListener(listener);
        }
    }

    public static void close(int performanceType, String title) {
        PerformanceDokitView performanceDokitView = DoKit.getDoKitView(ActivityUtils.getTopActivity(), PerformanceDokitView.class);
        if (performanceDokitView != null) {
            performanceDokitView.removeItem(performanceType);
        }
        singleperformanceViewInfos.remove(title);
    }

    public static String getTitleByPerformanceType(Context context, int performanceType) {
        String title = "";
        switch (performanceType) {
            case 4: {
                title = context.getString(R.string.dk_kit_frame_info_desc);
                break;
            }
            case 2: {
                title = context.getString(R.string.dk_frameinfo_cpu);
                break;
            }
            case 3: {
                title = context.getString(R.string.dk_ram_detection_title);
                break;
            }
            case 1: {
                title = context.getString(R.string.dk_kit_net_monitor);
                break;
            }
        }
        return title;
    }
}

