/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.ui;

import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.network.room_db.DokitDbManager;
import com.didichuxing.doraemonkit.kit.network.room_db.MockTemplateApiBean;
import com.didichuxing.doraemonkit.kit.network.ui.MockTemplatePreviewFragment;
import com.didichuxing.doraemonkit.kit.network.ui.TemplateMockAdapter;
import com.didichuxing.doraemonkit.util.DoKitCommUtil;
import com.didichuxing.doraemonkit.util.LogHelper;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.volley.VolleyManager;
import com.didichuxing.doraemonkit.widget.brvah.entity.node.BaseNode;
import com.didichuxing.doraemonkit.widget.brvah.provider.BaseNodeProvider;
import com.didichuxing.doraemonkit.widget.brvah.viewholder.BaseViewHolder;
import com.didichuxing.doraemonkit.widget.jsonviewer.JsonRecyclerView;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class TemplateDetailNodeProvider
extends BaseNodeProvider {
    private static final String TAG = "TemplateDetailNodeProvider";

    @Override
    public int getItemViewType() {
        return 200;
    }

    @Override
    public int getLayoutId() {
        return R.layout.dk_mock_template_content_item;
    }

    @Override
    public void convert(BaseViewHolder holder, BaseNode item) {
        if (item instanceof MockTemplateApiBean) {
            String hasLocalMockData;
            JSONObject jsonObject;
            final MockTemplateApiBean mockApi = (MockTemplateApiBean)item;
            holder.setText(R.id.tv_path, "path:" + mockApi.getPath());
            JsonRecyclerView jsonQuery = (JsonRecyclerView)((Object)holder.getView(R.id.jsonviewer_query));
            JsonRecyclerView jsonBody = (JsonRecyclerView)((Object)holder.getView(R.id.jsonviewer_body));
            try {
                holder.getView(R.id.rl_query).setVisibility(0);
                jsonObject = new JSONObject(mockApi.getQuery());
                if (jsonObject.length() == 0) {
                    holder.getView(R.id.rl_query).setVisibility(8);
                } else {
                    jsonQuery.bindJson(mockApi.getQuery());
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                holder.getView(R.id.rl_query).setVisibility(8);
            }
            try {
                holder.getView(R.id.rl_body).setVisibility(0);
                jsonObject = new JSONObject(mockApi.getBody());
                if (jsonObject.length() == 0) {
                    holder.getView(R.id.rl_body).setVisibility(8);
                } else {
                    jsonBody.bindJson(mockApi.getBody());
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                holder.getView(R.id.rl_body).setVisibility(8);
            }
            holder.setText(R.id.tv_group, "group:" + mockApi.getGroup());
            holder.setText(R.id.tv_create, "create person:" + mockApi.getCreatePerson());
            holder.setText(R.id.tv_modify, "modify person:" + mockApi.getModifyPerson());
            final TextView tvView = (TextView)holder.getView(R.id.tv_view);
            tvView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (TextUtils.isEmpty((CharSequence)mockApi.getStrResponse())) {
                        ToastUtils.showShort((CharSequence)"no mock template data");
                        return;
                    }
                    DokitDbManager.getInstance().setGlobalTemplateApiBean(mockApi);
                    DoKit.launchFullScreen(MockTemplatePreviewFragment.class, tvView.getContext());
                }
            });
            TextView tvUpload = (TextView)holder.getView(R.id.tv_upload);
            tvUpload.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    HashMap<String, String> values = new HashMap<String, String>();
                    values.put("projectId", mockApi.getProjectId());
                    values.put("id", mockApi.getId());
                    values.put("tempData", mockApi.getStrResponse());
                    JsonObjectRequest request2 = new JsonObjectRequest(7, TemplateMockAdapter.TEMPLATER_UPLOAD_URL, new JSONObject(values), (Response.Listener)new Response.Listener<JSONObject>(){

                        public void onResponse(JSONObject response) {
                            ToastUtils.showShort((CharSequence)"upload template succeed");
                            LogHelper.i(TemplateDetailNodeProvider.TAG, "\u4e0a\u4f20\u6a21\u677f===>" + response.toString());
                        }
                    }, new Response.ErrorListener(){

                        public void onErrorResponse(VolleyError error) {
                            ToastUtils.showShort((CharSequence)"upload template failed");
                            LogHelper.e(TemplateDetailNodeProvider.TAG, "error===>" + error.getMessage());
                        }
                    });
                    VolleyManager.INSTANCE.add(request2);
                }
            });
            TextView tvHasLocalMockData = (TextView)holder.getView(R.id.tv_local_has_mock_template);
            if (!TextUtils.isEmpty((CharSequence)mockApi.getStrResponse())) {
                hasLocalMockData = "Y";
                tvUpload.setClickable(true);
                tvUpload.setTextColor(tvUpload.getContext().getResources().getColor(R.color.dk_color_337CC4));
            } else {
                hasLocalMockData = "N";
                tvUpload.setClickable(false);
                tvUpload.setTextColor(tvUpload.getContext().getResources().getColor(R.color.dk_color_999999));
            }
            tvHasLocalMockData.setText((CharSequence)String.format(DoKitCommUtil.getString(R.string.dk_data_mock_template_tip), hasLocalMockData));
        }
    }
}

