/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.ui;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.config.DokitMemoryConfig;
import com.didichuxing.doraemonkit.kit.core.DoKitManager;
import com.didichuxing.doraemonkit.kit.core.SettingItem;
import com.didichuxing.doraemonkit.kit.core.SettingItemAdapter;
import com.didichuxing.doraemonkit.kit.network.NetworkManager;
import com.didichuxing.doraemonkit.kit.network.bean.WhiteHostBean;
import com.didichuxing.doraemonkit.kit.network.ui.NetWorkMainPagerFragment;
import com.didichuxing.doraemonkit.kit.network.ui.WhiteHostAdapter;
import com.didichuxing.doraemonkit.kit.parameter.AbsParameterFragment;
import com.didichuxing.doraemonkit.util.FileIOUtils;
import com.didichuxing.doraemonkit.util.FileUtils;
import com.didichuxing.doraemonkit.util.GsonUtils;
import com.didichuxing.doraemonkit.util.PathUtils;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NetWorkMonitorFragment
extends AbsParameterFragment {
    RecyclerView mHostRv;
    WhiteHostAdapter mHostAdapter;
    List<WhiteHostBean> mHostBeans = new ArrayList<WhiteHostBean>();
    private String whiteHostPath = PathUtils.getInternalAppFilesPath() + File.separator + "white_host.json";

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_net_monitor;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initCustomView();
    }

    @Override
    protected int getTitle() {
        return R.string.dk_kit_net_monitor;
    }

    @Override
    protected int getPerformanceType() {
        return 1;
    }

    @Override
    protected Collection<SettingItem> getSettingItems(List<SettingItem> list) {
        list.add(new SettingItem(R.string.dk_net_monitor_detection_switch, NetworkManager.isActive()));
        return list;
    }

    @Override
    protected SettingItemAdapter.OnSettingItemSwitchListener getItemSwitchListener() {
        return new SettingItemAdapter.OnSettingItemSwitchListener(){

            @Override
            public void onSettingItemSwitch(View view, SettingItem data, boolean on) {
                if (on) {
                    NetWorkMonitorFragment.this.startMonitor();
                } else {
                    NetWorkMonitorFragment.this.stopMonitor();
                }
                DokitMemoryConfig.NETWORK_STATUS = on;
            }
        };
    }

    @Override
    protected SettingItemAdapter.OnSettingItemClickListener getItemClickListener() {
        return new SettingItemAdapter.OnSettingItemClickListener(){

            @Override
            public void onSettingItemClick(View view, SettingItem data) {
            }
        };
    }

    private void initCustomView() {
        this.findViewById(R.id.btn_net_summary).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NetWorkMonitorFragment.this.showContent(NetWorkMainPagerFragment.class);
            }
        });
        this.mHostRv = (RecyclerView)this.findViewById(R.id.host_list);
        this.mHostRv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        if (DoKitManager.WHITE_HOSTS.isEmpty()) {
            String whiteHostArray = FileIOUtils.readFile2String((String)this.whiteHostPath);
            if (TextUtils.isEmpty((CharSequence)whiteHostArray)) {
                this.mHostBeans.add(new WhiteHostBean("", true));
            } else {
                this.mHostBeans = (List)GsonUtils.fromJson((String)whiteHostArray, (Type)GsonUtils.getListType(WhiteHostBean.class));
                DoKitManager.WHITE_HOSTS.clear();
                DoKitManager.WHITE_HOSTS.addAll(this.mHostBeans);
            }
        } else {
            this.mHostBeans.addAll(DoKitManager.WHITE_HOSTS);
        }
        this.mHostAdapter = new WhiteHostAdapter(R.layout.dk_item_white_host, this.mHostBeans);
        this.mHostRv.setAdapter((RecyclerView.Adapter)this.mHostAdapter);
    }

    private void startMonitor() {
        NetworkManager.get().startMonitor();
        this.openChartPage(R.string.dk_kit_net_monitor, 1);
    }

    private void stopMonitor() {
        NetworkManager.get().stopMonitor();
        this.closeChartPage();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        List hostBeans = this.mHostAdapter.getData();
        if (hostBeans.size() == 1 && TextUtils.isEmpty((CharSequence)((WhiteHostBean)hostBeans.get(0)).getHost())) {
            DoKitManager.WHITE_HOSTS.clear();
            FileUtils.delete((String)this.whiteHostPath);
            return;
        }
        DoKitManager.WHITE_HOSTS.clear();
        DoKitManager.WHITE_HOSTS.addAll(hostBeans);
        String hostArray = GsonUtils.toJson(hostBeans);
        FileUtils.delete((String)this.whiteHostPath);
        FileIOUtils.writeFileFromString((String)this.whiteHostPath, (String)hostArray);
    }
}

