/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.ui;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.core.DoKitManager;
import com.didichuxing.doraemonkit.kit.network.bean.MockApiResponseBean;
import com.didichuxing.doraemonkit.kit.network.bean.MockInterceptTitleBean;
import com.didichuxing.doraemonkit.kit.network.bean.MockTemplateTitleBean;
import com.didichuxing.doraemonkit.kit.network.room_db.DokitDbManager;
import com.didichuxing.doraemonkit.kit.network.room_db.MockInterceptApiBean;
import com.didichuxing.doraemonkit.kit.network.room_db.MockTemplateApiBean;
import com.didichuxing.doraemonkit.kit.network.ui.InterceptMockAdapter;
import com.didichuxing.doraemonkit.kit.network.ui.ListDropDownAdapter;
import com.didichuxing.doraemonkit.kit.network.ui.TemplateMockAdapter;
import com.didichuxing.doraemonkit.util.ConvertUtils;
import com.didichuxing.doraemonkit.util.DoKitCommUtil;
import com.didichuxing.doraemonkit.util.GsonUtils;
import com.didichuxing.doraemonkit.util.LogHelper;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.volley.VolleyManager;
import com.didichuxing.doraemonkit.widget.brvah.entity.node.BaseNode;
import com.didichuxing.doraemonkit.widget.brvah.listener.OnLoadMoreListener;
import com.didichuxing.doraemonkit.widget.brvah.module.BaseLoadMoreModule;
import com.didichuxing.doraemonkit.widget.dropdown.DkDropDownMenu;
import com.didichuxing.doraemonkit.widget.easyrefresh.EasyRefreshLayout;
import com.didichuxing.doraemonkit.widget.easyrefresh.LoadModel;
import com.didichuxing.doraemonkit.widget.titlebar.HomeTitleBar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class NetWorkMockFragment
extends BaseFragment {
    private String projectId = DoKitManager.PRODUCT_ID;
    private int pageSize = 50;
    private String mFormatApiUrl = "https://mock.dokit.cn/api/app/interface?projectId=%s&isfull=1&curPage=%s&pageSize=%s";
    private EditText mEditText;
    private EasyRefreshLayout mInterceptRefreshLayout;
    private EasyRefreshLayout mTemplateRefreshLayout;
    private InterceptMockAdapter mInterceptApiAdapter;
    private TemplateMockAdapter mTemplateApiAdapter;
    private BaseLoadMoreModule mInterceptLoadMoreModule;
    private BaseLoadMoreModule mTemplateLoadMoreModule;
    private RecyclerView mRvIntercept;
    private RecyclerView mRvTemplate;
    private FrameLayout mRvWrap;
    private TextView mTvMock;
    private TextView mTvTemplate;
    private ImageView mIvMock;
    private ImageView mIvTemplate;
    private String[] mMenuHeaders = new String[]{DoKitCommUtil.getString(R.string.dk_data_mock_group), DoKitCommUtil.getString(R.string.dk_data_mock_switch_status)};
    private DkDropDownMenu mDropDownMenu;
    private ListDropDownAdapter mGroupMenuAdapter;
    private ListDropDownAdapter mSwitchMenuAdapter;
    private String[] mSwitchMenus = new String[]{DoKitCommUtil.getString(R.string.dk_data_mock_switch_all), DoKitCommUtil.getString(R.string.dk_data_mock_switch_opened), DoKitCommUtil.getString(R.string.dk_data_mock_switch_closed)};
    private List<View> popupViews = new ArrayList<View>();
    private FilterConditionBean mInterceptFilterBean;
    private FilterConditionBean mTemplateFilterBean;
    private static int BOTTOM_TAB_INDEX_0 = 0;
    private static int BOTTOM_TAB_INDEX_1 = 1;
    private int mSelectedTableIndex = BOTTOM_TAB_INDEX_0;
    HomeTitleBar mHomeTitleBar;
    private String mStrInterceptGroup = "";
    private String mStrTemplateGroup = "";
    private int mInterceptOpenStatus = 0;
    private int mTemplateOpenStatus = 0;
    private List<MockInterceptTitleBean> mInterceptTitleBeans = new ArrayList<MockInterceptTitleBean>();
    private List<MockTemplateTitleBean> mTemplateTitleBeans = new ArrayList<MockTemplateTitleBean>();
    String initMockInterceptResponse = "";
    String initTemplateInterceptResponse = "";

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView();
    }

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_net_mock;
    }

    private void initView() {
        if (this.getActivity() == null) {
            return;
        }
        this.mHomeTitleBar = (HomeTitleBar)((Object)this.findViewById(R.id.title_bar));
        this.mHomeTitleBar.setListener(new HomeTitleBar.OnTitleBarClickListener(){

            @Override
            public void onRightClick() {
                NetWorkMockFragment.this.finish();
            }
        });
        if (TextUtils.isEmpty((CharSequence)this.projectId)) {
            ToastUtils.showLong((CharSequence)DoKitCommUtil.getString(R.string.dk_data_mock_plugin_toast));
            return;
        }
        this.mEditText = (EditText)this.findViewById(R.id.edittext);
        TextView mTvSearch = (TextView)this.findViewById(R.id.tv_search);
        mTvSearch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_0) {
                    NetWorkMockFragment.this.mInterceptFilterBean.setFilterText(NetWorkMockFragment.this.mEditText.getText().toString());
                } else if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_1) {
                    NetWorkMockFragment.this.mTemplateFilterBean.setFilterText(NetWorkMockFragment.this.mEditText.getText().toString());
                }
                NetWorkMockFragment.this.filterAndNotifyData();
            }
        });
        LinearLayout mLlBottomInterceptWrap = (LinearLayout)this.findViewById(R.id.ll_bottom_tab_mock);
        mLlBottomInterceptWrap.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NetWorkMockFragment.this.switchBottomTabStatus(BOTTOM_TAB_INDEX_0);
            }
        });
        LinearLayout mLlBottomTemplateWrap = (LinearLayout)this.findViewById(R.id.ll_bottom_tab_template);
        mLlBottomTemplateWrap.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NetWorkMockFragment.this.switchBottomTabStatus(BOTTOM_TAB_INDEX_1);
            }
        });
        this.mTvMock = (TextView)this.findViewById(R.id.tv_mock);
        this.mTvTemplate = (TextView)this.findViewById(R.id.tv_template);
        this.mIvMock = (ImageView)this.findViewById(R.id.iv_mock);
        this.mIvTemplate = (ImageView)this.findViewById(R.id.iv_template);
        this.mDropDownMenu = (DkDropDownMenu)((Object)this.findViewById(R.id.drop_down_menu));
        this.mRvWrap = new FrameLayout((Context)this.getActivity());
        this.mInterceptRefreshLayout = new EasyRefreshLayout((Context)this.getActivity());
        this.mInterceptRefreshLayout.setBackgroundColor(this.getResources().getColor(R.color.dk_color_FFFFFF));
        this.mRvIntercept = new RecyclerView((Context)this.getActivity());
        this.mInterceptRefreshLayout.addView((View)this.mRvIntercept);
        this.mInterceptRefreshLayout.setLoadMoreModel(LoadModel.NONE);
        this.mInterceptRefreshLayout.setEnablePullToRefresh(false);
        this.mInterceptRefreshLayout.addEasyEvent(new EasyRefreshLayout.EasyEvent(){

            @Override
            public void onLoadMore() {
            }

            @Override
            public void onRefreshing() {
                NetWorkMockFragment.this.initResponseApis(1);
            }
        });
        this.mTemplateRefreshLayout = new EasyRefreshLayout((Context)this.getActivity());
        this.mTemplateRefreshLayout.setBackgroundColor(this.getResources().getColor(R.color.dk_color_FFFFFF));
        this.mRvTemplate = new RecyclerView((Context)this.getActivity());
        this.mTemplateRefreshLayout.addView((View)this.mRvTemplate);
        this.mTemplateRefreshLayout.setLoadMoreModel(LoadModel.NONE);
        this.mTemplateRefreshLayout.setEnablePullToRefresh(false);
        this.mTemplateRefreshLayout.addEasyEvent(new EasyRefreshLayout.EasyEvent(){

            @Override
            public void onLoadMore() {
            }

            @Override
            public void onRefreshing() {
                NetWorkMockFragment.this.initResponseApis(1);
            }
        });
        this.mRvWrap.setBackgroundColor(this.getResources().getColor(R.color.dk_color_F5F6F7));
        this.mRvWrap.setPadding(0, ConvertUtils.dp2px((float)4.0f), 0, 0);
        this.mRvWrap.addView((View)this.mInterceptRefreshLayout);
        this.mRvWrap.addView((View)this.mTemplateRefreshLayout);
        this.mRvIntercept.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        this.mRvTemplate.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        this.initResponseApis(1);
    }

    private void filterAndNotifyData() {
        String strFilter = this.mEditText.getText().toString();
        if (this.mSelectedTableIndex == BOTTOM_TAB_INDEX_0) {
            ArrayList<BaseNode> interceptTitleBeans = new ArrayList<BaseNode>();
            for (MockInterceptTitleBean interceptTitleBean : this.mInterceptTitleBeans) {
                MockInterceptApiBean interceptApiBean = (MockInterceptApiBean)interceptTitleBean.getChildNode().get(0);
                boolean boolGroupMatched = TextUtils.isEmpty((CharSequence)this.mStrInterceptGroup) ? true : interceptApiBean.getGroup().equals(this.mStrInterceptGroup);
                boolean boolSwitchOpenMatched = this.mInterceptOpenStatus == 0 ? true : (this.mInterceptOpenStatus == 1 ? interceptApiBean.isOpen() : (this.mInterceptOpenStatus == 2 ? !interceptApiBean.isOpen() : false));
                boolean boolStrFilterMatched = TextUtils.isEmpty((CharSequence)strFilter) ? true : interceptApiBean.getMockApiName().contains(strFilter);
                if (!boolGroupMatched || !boolSwitchOpenMatched || !boolStrFilterMatched) continue;
                interceptTitleBeans.add(interceptTitleBean);
            }
            this.mInterceptApiAdapter.setNewInstance((List<BaseNode>)interceptTitleBeans);
            this.mInterceptLoadMoreModule.loadMoreEnd();
            if (interceptTitleBeans.isEmpty()) {
                this.mInterceptApiAdapter.setEmptyView(R.layout.dk_rv_empty_layout2);
            }
            this.mHomeTitleBar.setTitle(DoKitCommUtil.getString(R.string.dk_kit_network_mock) + "(" + interceptTitleBeans.size() + ")");
        } else if (this.mSelectedTableIndex == BOTTOM_TAB_INDEX_1) {
            ArrayList<BaseNode> templateTitleBeans = new ArrayList<BaseNode>();
            for (MockTemplateTitleBean templateTitleBean : this.mTemplateTitleBeans) {
                MockTemplateApiBean templateApiBean = (MockTemplateApiBean)templateTitleBean.getChildNode().get(0);
                boolean boolGroupMatched = TextUtils.isEmpty((CharSequence)this.mStrTemplateGroup) ? true : templateApiBean.getGroup().equals(this.mStrTemplateGroup);
                boolean boolSwitchOpenMatched = this.mTemplateOpenStatus == 0 ? true : (this.mTemplateOpenStatus == 1 ? templateApiBean.isOpen() : (this.mTemplateOpenStatus == 2 ? !templateApiBean.isOpen() : false));
                boolean boolStrFilterMatched = TextUtils.isEmpty((CharSequence)strFilter) ? true : templateApiBean.getMockApiName().contains(strFilter);
                if (!boolGroupMatched || !boolSwitchOpenMatched || !boolStrFilterMatched) continue;
                templateTitleBeans.add(templateTitleBean);
            }
            this.mTemplateApiAdapter.setNewInstance((List<BaseNode>)templateTitleBeans);
            this.mTemplateLoadMoreModule.loadMoreEnd();
            if (templateTitleBeans.isEmpty()) {
                this.mTemplateApiAdapter.setEmptyView(R.layout.dk_rv_empty_layout2);
            }
            this.mHomeTitleBar.setTitle(DoKitCommUtil.getString(R.string.dk_kit_network_mock) + "(" + templateTitleBeans.size() + ")");
        }
    }

    private void attachInterceptRv(@NonNull List<MockInterceptTitleBean> mockTitleBeans) {
        this.mInterceptTitleBeans.addAll(mockTitleBeans);
        this.mInterceptRefreshLayout.refreshComplete();
        if (this.mInterceptApiAdapter == null) {
            this.mInterceptApiAdapter = new InterceptMockAdapter(null);
            this.mRvIntercept.setAdapter((RecyclerView.Adapter)this.mInterceptApiAdapter);
            this.mInterceptLoadMoreModule = this.mInterceptApiAdapter.getLoadMoreModule();
            this.mInterceptLoadMoreModule.setEnableLoadMore(false);
            this.mInterceptLoadMoreModule.setOnLoadMoreListener(new OnLoadMoreListener(){

                @Override
                public void onLoadMore() {
                    if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_0) {
                        NetWorkMockFragment.this.mInterceptLoadMoreModule.loadMoreEnd();
                    } else if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_1) {
                        NetWorkMockFragment.this.mTemplateLoadMoreModule.loadMoreEnd();
                    }
                }
            });
            this.mInterceptLoadMoreModule.setEnableLoadMoreIfNotFullPage(false);
        }
        if (mockTitleBeans.isEmpty()) {
            this.mInterceptApiAdapter.setEmptyView(R.layout.dk_rv_empty_layout);
            return;
        }
        this.mInterceptApiAdapter.setNewInstance(mockTitleBeans);
        if (mockTitleBeans.size() < this.pageSize) {
            this.mInterceptLoadMoreModule.loadMoreEnd();
        }
    }

    private void attachTemplateRv(@NonNull List<MockTemplateTitleBean> mockTitleBeans) {
        this.mTemplateTitleBeans.addAll(mockTitleBeans);
        this.mTemplateRefreshLayout.refreshComplete();
        if (this.mTemplateApiAdapter == null) {
            this.mTemplateApiAdapter = new TemplateMockAdapter(null);
            this.mRvTemplate.setAdapter((RecyclerView.Adapter)this.mTemplateApiAdapter);
            this.mTemplateLoadMoreModule = this.mTemplateApiAdapter.getLoadMoreModule();
            this.mTemplateLoadMoreModule.setEnableLoadMore(false);
            this.mTemplateLoadMoreModule.setOnLoadMoreListener(new OnLoadMoreListener(){

                @Override
                public void onLoadMore() {
                    if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_0) {
                        NetWorkMockFragment.this.mInterceptLoadMoreModule.loadMoreEnd();
                    } else if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_1) {
                        NetWorkMockFragment.this.mTemplateLoadMoreModule.loadMoreEnd();
                    }
                }
            });
            this.mTemplateLoadMoreModule.setEnableLoadMoreIfNotFullPage(false);
        }
        if (mockTitleBeans.isEmpty()) {
            this.mTemplateApiAdapter.setEmptyView(R.layout.dk_rv_empty_layout);
            return;
        }
        this.mTemplateApiAdapter.setNewInstance(mockTitleBeans);
        if (mockTitleBeans.size() < this.pageSize) {
            this.mTemplateLoadMoreModule.loadMoreEnd();
        }
    }

    private void loadMoreInterceptDates(List<MockInterceptTitleBean> mockTitleBeans) {
        this.mInterceptApiAdapter.addData((Collection<? extends BaseNode>)mockTitleBeans);
        if (mockTitleBeans.size() < this.pageSize) {
            this.mInterceptLoadMoreModule.loadMoreEnd();
        } else {
            this.mInterceptLoadMoreModule.loadMoreComplete();
        }
    }

    private void loadMoreTemplateDates(List<MockTemplateTitleBean> mockTitleBeans) {
        this.mTemplateApiAdapter.addData((Collection<? extends BaseNode>)mockTitleBeans);
        if (mockTitleBeans.size() < this.pageSize) {
            this.mTemplateLoadMoreModule.loadMoreEnd();
        } else {
            this.mTemplateLoadMoreModule.loadMoreComplete();
        }
    }

    private void loadMoreResponseApis() {
        int curPage = 1;
        if (this.mSelectedTableIndex == BOTTOM_TAB_INDEX_0) {
            curPage = this.mInterceptApiAdapter.getData().size() / this.pageSize + 1;
        } else if (this.mSelectedTableIndex == BOTTOM_TAB_INDEX_1) {
            curPage = this.mTemplateApiAdapter.getData().size() / this.pageSize + 1;
        }
        String apiUrl = String.format(this.mFormatApiUrl, this.projectId, curPage, this.pageSize);
        StringRequest request2 = new StringRequest(0, apiUrl, (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                block6: {
                    try {
                        if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_0) {
                            List mockInterceptTitleBeans = NetWorkMockFragment.this.dealInterceptResponseData(response);
                            NetWorkMockFragment.this.loadMoreInterceptDates(mockInterceptTitleBeans);
                        } else if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_1) {
                            List mockTemplateTitleBeans = NetWorkMockFragment.this.dealTemplateResponseData(response);
                            NetWorkMockFragment.this.loadMoreTemplateDates(mockTemplateTitleBeans);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_0) {
                            NetWorkMockFragment.this.mInterceptLoadMoreModule.loadMoreEnd();
                        }
                        if (NetWorkMockFragment.this.mSelectedTableIndex != BOTTOM_TAB_INDEX_1) break block6;
                        NetWorkMockFragment.this.mTemplateLoadMoreModule.loadMoreEnd();
                    }
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_0) {
                    NetWorkMockFragment.this.mInterceptLoadMoreModule.loadMoreEnd();
                } else if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_1) {
                    NetWorkMockFragment.this.mTemplateLoadMoreModule.loadMoreEnd();
                }
            }
        });
        VolleyManager.INSTANCE.add(request2);
    }

    private void initMenus(List<MockInterceptTitleBean> mockInterceptTitleBeans) {
        final ArrayList<String> groups = new ArrayList<String>();
        groups.add(DoKitCommUtil.getString(R.string.dk_data_mock_group));
        for (MockInterceptTitleBean mockInterceptTitleBean : mockInterceptTitleBeans) {
            MockInterceptApiBean mockInterceptApiBean = (MockInterceptApiBean)mockInterceptTitleBean.getChildNode().get(0);
            if (groups.contains(mockInterceptApiBean.getGroup())) continue;
            groups.add(mockInterceptApiBean.getGroup());
        }
        ListView mGroupListView = new ListView((Context)this.getActivity());
        mGroupListView.setDividerHeight(0);
        this.mGroupMenuAdapter = new ListDropDownAdapter((Context)this.getActivity(), groups);
        mGroupListView.setAdapter((ListAdapter)this.mGroupMenuAdapter);
        mGroupListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                NetWorkMockFragment.this.mGroupMenuAdapter.setCheckItem(position);
                NetWorkMockFragment.this.mDropDownMenu.setTabText((String)groups.get(position));
                NetWorkMockFragment.this.mDropDownMenu.closeMenu();
                if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_0) {
                    NetWorkMockFragment.this.mInterceptFilterBean.setGroupIndex(position);
                    NetWorkMockFragment.this.mStrInterceptGroup = ((String)groups.get(position)).equals(DoKitCommUtil.getString(R.string.dk_data_mock_group)) ? "" : (String)groups.get(position);
                } else if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_1) {
                    NetWorkMockFragment.this.mTemplateFilterBean.setGroupIndex(position);
                    NetWorkMockFragment.this.mStrTemplateGroup = ((String)groups.get(position)).equals(DoKitCommUtil.getString(R.string.dk_data_mock_group)) ? "" : (String)groups.get(position);
                }
                NetWorkMockFragment.this.filterAndNotifyData();
            }
        });
        ListView mSwitchListView = new ListView((Context)this.getActivity());
        mSwitchListView.setDividerHeight(0);
        this.mSwitchMenuAdapter = new ListDropDownAdapter((Context)this.getActivity(), Arrays.asList(this.mSwitchMenus));
        mSwitchListView.setAdapter((ListAdapter)this.mSwitchMenuAdapter);
        mSwitchListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                NetWorkMockFragment.this.mSwitchMenuAdapter.setCheckItem(position);
                NetWorkMockFragment.this.mDropDownMenu.setTabText(NetWorkMockFragment.this.mSwitchMenus[position]);
                NetWorkMockFragment.this.mDropDownMenu.closeMenu();
                if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_0) {
                    NetWorkMockFragment.this.mInterceptFilterBean.setSwitchIndex(position);
                    NetWorkMockFragment.this.mInterceptOpenStatus = position;
                } else if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_1) {
                    NetWorkMockFragment.this.mTemplateFilterBean.setSwitchIndex(position);
                    NetWorkMockFragment.this.mTemplateOpenStatus = position;
                }
                NetWorkMockFragment.this.filterAndNotifyData();
            }
        });
        this.popupViews.add((View)mGroupListView);
        this.popupViews.add((View)mSwitchListView);
        this.mDropDownMenu.setDropDownMenu(Arrays.asList(this.mMenuHeaders), this.popupViews, (View)this.mRvWrap);
        this.mInterceptFilterBean = new FilterConditionBean();
        this.mInterceptFilterBean.setFilterText("");
        this.mInterceptFilterBean.setGroupIndex(0);
        this.mInterceptFilterBean.setSwitchIndex(0);
        this.mTemplateFilterBean = new FilterConditionBean();
        this.mTemplateFilterBean.setFilterText("");
        this.mTemplateFilterBean.setGroupIndex(0);
        this.mTemplateFilterBean.setSwitchIndex(0);
        this.switchBottomTabStatus(BOTTOM_TAB_INDEX_0);
    }

    private void initResponseApis(int currentPage) {
        if (currentPage == 1) {
            if (this.mSelectedTableIndex == BOTTOM_TAB_INDEX_0) {
                this.initMockInterceptResponse = "";
            } else if (this.mSelectedTableIndex == BOTTOM_TAB_INDEX_1) {
                this.initTemplateInterceptResponse = "";
            }
        }
        String apiUrl = String.format(this.mFormatApiUrl, this.projectId, currentPage, this.pageSize);
        LogHelper.i(this.TAG, "apiUrl===>" + apiUrl);
        StringRequest request2 = new StringRequest(0, apiUrl, (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                block14: {
                    try {
                        if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_0) {
                            MockApiResponseBean AllMockApiResponseBean;
                            MockApiResponseBean mockApiResponseBean = (MockApiResponseBean)GsonUtils.fromJson((String)response, MockApiResponseBean.class);
                            List<MockApiResponseBean.DataBean.DatalistBean> lists = mockApiResponseBean.getData().getDatalist();
                            if (NetWorkMockFragment.this.initMockInterceptResponse.isEmpty()) {
                                NetWorkMockFragment.this.initMockInterceptResponse = response;
                            } else {
                                AllMockApiResponseBean = (MockApiResponseBean)GsonUtils.fromJson((String)NetWorkMockFragment.this.initMockInterceptResponse, MockApiResponseBean.class);
                                List<MockApiResponseBean.DataBean.DatalistBean> AllLists = AllMockApiResponseBean.getData().getDatalist();
                                AllLists.addAll(lists);
                                NetWorkMockFragment.this.initMockInterceptResponse = GsonUtils.toJson((Object)AllMockApiResponseBean);
                            }
                            if (lists.size() < NetWorkMockFragment.this.pageSize) {
                                List mockInterceptTitleBeans = NetWorkMockFragment.this.dealInterceptResponseData(NetWorkMockFragment.this.initMockInterceptResponse);
                                NetWorkMockFragment.this.initMenus(mockInterceptTitleBeans);
                                NetWorkMockFragment.this.attachInterceptRv(mockInterceptTitleBeans);
                                NetWorkMockFragment.this.mHomeTitleBar.setTitle(DoKitCommUtil.getString(R.string.dk_kit_network_mock) + "(" + mockInterceptTitleBeans.size() + ")");
                            } else {
                                AllMockApiResponseBean = (MockApiResponseBean)GsonUtils.fromJson((String)NetWorkMockFragment.this.initMockInterceptResponse, MockApiResponseBean.class);
                                NetWorkMockFragment.this.initResponseApis(AllMockApiResponseBean.getData().getDatalist().size() / NetWorkMockFragment.this.pageSize + 1);
                            }
                        } else if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_1) {
                            MockApiResponseBean AllMockApiResponseBean;
                            MockApiResponseBean mockApiResponseBean = (MockApiResponseBean)GsonUtils.fromJson((String)response, MockApiResponseBean.class);
                            List<MockApiResponseBean.DataBean.DatalistBean> lists = mockApiResponseBean.getData().getDatalist();
                            if (NetWorkMockFragment.this.initTemplateInterceptResponse.isEmpty()) {
                                NetWorkMockFragment.this.initTemplateInterceptResponse = response;
                            } else {
                                AllMockApiResponseBean = (MockApiResponseBean)GsonUtils.fromJson((String)NetWorkMockFragment.this.initMockInterceptResponse, MockApiResponseBean.class);
                                List<MockApiResponseBean.DataBean.DatalistBean> AllLists = AllMockApiResponseBean.getData().getDatalist();
                                AllLists.addAll(lists);
                                NetWorkMockFragment.this.initTemplateInterceptResponse = GsonUtils.toJson((Object)AllMockApiResponseBean);
                            }
                            if (lists.size() < NetWorkMockFragment.this.pageSize) {
                                List mockInterceptTitleBeans = NetWorkMockFragment.this.dealTemplateResponseData(NetWorkMockFragment.this.initTemplateInterceptResponse);
                                NetWorkMockFragment.this.attachTemplateRv(mockInterceptTitleBeans);
                                NetWorkMockFragment.this.mHomeTitleBar.setTitle(DoKitCommUtil.getString(R.string.dk_kit_network_mock) + "(" + mockInterceptTitleBeans.size() + ")");
                            } else {
                                AllMockApiResponseBean = (MockApiResponseBean)GsonUtils.fromJson((String)NetWorkMockFragment.this.initTemplateInterceptResponse, MockApiResponseBean.class);
                                NetWorkMockFragment.this.initResponseApis(AllMockApiResponseBean.getData().getDatalist().size() / NetWorkMockFragment.this.pageSize + 1);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_0) {
                            NetWorkMockFragment.this.mInterceptRefreshLayout.refreshComplete();
                            NetWorkMockFragment.this.mHomeTitleBar.setTitle(DoKitCommUtil.getString(R.string.dk_kit_network_mock) + "(0)");
                        }
                        if (NetWorkMockFragment.this.mSelectedTableIndex != BOTTOM_TAB_INDEX_1) break block14;
                        NetWorkMockFragment.this.mTemplateRefreshLayout.refreshComplete();
                        NetWorkMockFragment.this.mHomeTitleBar.setTitle(DoKitCommUtil.getString(R.string.dk_kit_network_mock) + "(0)");
                    }
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                LogHelper.e(NetWorkMockFragment.this.TAG, "error====>" + error.getMessage());
                ToastUtils.showShort((CharSequence)error.getMessage());
                if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_0) {
                    NetWorkMockFragment.this.mInterceptRefreshLayout.refreshComplete();
                } else if (NetWorkMockFragment.this.mSelectedTableIndex == BOTTOM_TAB_INDEX_1) {
                    NetWorkMockFragment.this.mTemplateRefreshLayout.refreshComplete();
                }
            }
        });
        VolleyManager.INSTANCE.add(request2);
    }

    @NonNull
    private List<MockInterceptTitleBean> dealInterceptResponseData(String strResponse) throws Exception {
        JSONObject responseJsonObject = new JSONObject(strResponse);
        JSONArray jsonArray = responseJsonObject.getJSONObject("data").getJSONArray("datalist");
        MockApiResponseBean mockApiResponseBean = (MockApiResponseBean)GsonUtils.fromJson((String)strResponse, MockApiResponseBean.class);
        List<MockApiResponseBean.DataBean.DatalistBean> lists = mockApiResponseBean.getData().getDatalist();
        ArrayList<MockInterceptTitleBean> mockInterceptTitleBeans = new ArrayList<MockInterceptTitleBean>();
        for (int index = 0; index < lists.size(); ++index) {
            MockApiResponseBean.DataBean.DatalistBean datalistBean = lists.get(index);
            JSONObject mockJsonObject = jsonArray.getJSONObject(index);
            JSONObject queryJsonObject = mockJsonObject.has("query") ? mockJsonObject.getJSONObject("query") : new JSONObject();
            JSONObject bodyJsonObject = mockJsonObject.has("body") ? mockJsonObject.getJSONObject("body") : new JSONObject();
            String modifyName = "null";
            if (datalistBean.getCurStatus() != null && datalistBean.getCurStatus().getOperator() != null) {
                modifyName = datalistBean.getCurStatus().getOperator().getName();
            }
            ArrayList<MockInterceptApiBean> mockInterceptApiBeans = new ArrayList<MockInterceptApiBean>();
            mockInterceptApiBeans.add(new MockInterceptApiBean(datalistBean.get_id(), datalistBean.getName(), datalistBean.getPath(), datalistBean.getMethod(), datalistBean.getFormatType(), queryJsonObject.toString(), bodyJsonObject.toString(), datalistBean.getCategoryName(), datalistBean.getOwner().getName(), modifyName, datalistBean.getSceneList()));
            MockInterceptTitleBean mockInterceptTitleBean = new MockInterceptTitleBean(datalistBean.getName(), mockInterceptApiBeans);
            mockInterceptTitleBeans.add(mockInterceptTitleBean);
        }
        this.insertAllInterceptApis(mockInterceptTitleBeans);
        return mockInterceptTitleBeans;
    }

    @NonNull
    private List<MockTemplateTitleBean> dealTemplateResponseData(String strResponse) throws Exception {
        JSONObject responseJsonObject = new JSONObject(strResponse);
        JSONArray jsonArray = responseJsonObject.getJSONObject("data").getJSONArray("datalist");
        MockApiResponseBean mockApiResponseBean = (MockApiResponseBean)GsonUtils.fromJson((String)strResponse, MockApiResponseBean.class);
        List<MockApiResponseBean.DataBean.DatalistBean> lists = mockApiResponseBean.getData().getDatalist();
        ArrayList<MockTemplateTitleBean> mockTemplateTitleBeans = new ArrayList<MockTemplateTitleBean>();
        for (int index = 0; index < lists.size(); ++index) {
            MockApiResponseBean.DataBean.DatalistBean datalistBean = lists.get(index);
            JSONObject mockJsonObject = jsonArray.getJSONObject(index);
            JSONObject queryJsonObject = mockJsonObject.has("query") ? mockJsonObject.getJSONObject("query") : new JSONObject();
            JSONObject bodyJsonObject = mockJsonObject.has("body") ? mockJsonObject.getJSONObject("body") : new JSONObject();
            String modifyName = "null";
            if (datalistBean.getCurStatus() != null && datalistBean.getCurStatus().getOperator() != null) {
                modifyName = datalistBean.getCurStatus().getOperator().getName();
            }
            ArrayList<MockTemplateApiBean> mockTemplateApiBeans = new ArrayList<MockTemplateApiBean>();
            mockTemplateApiBeans.add(new MockTemplateApiBean(datalistBean.get_id(), datalistBean.getName(), datalistBean.getPath(), datalistBean.getMethod(), datalistBean.getFormatType(), queryJsonObject.toString(), bodyJsonObject.toString(), datalistBean.getCategoryName(), datalistBean.getOwner().getName(), modifyName, datalistBean.getProjectId()));
            MockTemplateTitleBean mockTemplateTitleBean = new MockTemplateTitleBean(datalistBean.getName(), mockTemplateApiBeans);
            mockTemplateTitleBeans.add(mockTemplateTitleBean);
        }
        this.insertAllTemplateApis(mockTemplateTitleBeans);
        return mockTemplateTitleBeans;
    }

    private void insertAllInterceptApis(ArrayList<MockInterceptTitleBean> mockTitleBeans) {
        ArrayList<MockInterceptApiBean> mockApis = new ArrayList<MockInterceptApiBean>();
        for (MockInterceptTitleBean mockInterceptTitleBean : mockTitleBeans) {
            MockInterceptApiBean mockApi = (MockInterceptApiBean)mockInterceptTitleBean.getChildNode().get(0);
            if (!this.hasInterceptApiInDb(mockApi.getPath(), mockApi.getId())) {
                mockApis.add(mockApi);
                continue;
            }
            this.updateInterceptApi(mockApi);
        }
        DokitDbManager.getInstance().insertAllInterceptApi(mockApis);
    }

    private void insertAllTemplateApis(ArrayList<MockTemplateTitleBean> mockTitleBeans) {
        ArrayList<MockTemplateApiBean> mockApis = new ArrayList<MockTemplateApiBean>();
        for (MockTemplateTitleBean mockTemplateTitleBean : mockTitleBeans) {
            MockTemplateApiBean mockApi = (MockTemplateApiBean)mockTemplateTitleBean.getChildNode().get(0);
            if (!this.hasTemplateApiInDb(mockApi.getPath(), mockApi.getId())) {
                mockApis.add(mockApi);
                continue;
            }
            this.updateTemplateApi(mockApi);
        }
        DokitDbManager.getInstance().insertAllTemplateApi(mockApis);
    }

    private void updateInterceptApi(MockInterceptApiBean mockApi) {
        List localInterceptApis = DokitDbManager.getInstance().getGlobalInterceptApiMaps().get(mockApi.getPath());
        if (localInterceptApis == null) {
            return;
        }
        for (MockInterceptApiBean localMockApi : localInterceptApis) {
            if (!localMockApi.getId().equals(mockApi.getId())) continue;
            mockApi.setOpen(localMockApi.isOpen());
            mockApi.setSelectedSceneId(localMockApi.getSelectedSceneId());
            mockApi.setSelectedSceneName(localMockApi.getSelectedSceneName());
            break;
        }
    }

    private void updateTemplateApi(MockTemplateApiBean mockApi) {
        List localTemplateApis = DokitDbManager.getInstance().getGlobalTemplateApiMaps().get(mockApi.getPath());
        if (localTemplateApis == null) {
            return;
        }
        for (MockTemplateApiBean localMockApi : localTemplateApis) {
            if (!localMockApi.getId().equals(mockApi.getId())) continue;
            mockApi.setOpen(localMockApi.isOpen());
            mockApi.setResponseFrom(localMockApi.getResponseFrom());
            mockApi.setStrResponse(localMockApi.getStrResponse());
            break;
        }
    }

    private boolean hasInterceptApiInDb(String path, String id2) {
        MockInterceptApiBean mockInterceptApi = (MockInterceptApiBean)DokitDbManager.getInstance().getInterceptApiByIdInMap(path, id2, DokitDbManager.FROM_SDK_OTHER);
        return mockInterceptApi != null;
    }

    private boolean hasTemplateApiInDb(String path, String id2) {
        MockTemplateApiBean mockTemplateApi = (MockTemplateApiBean)DokitDbManager.getInstance().getTemplateApiByIdInMap(path, id2, DokitDbManager.FROM_SDK_OTHER);
        return mockTemplateApi != null;
    }

    private void switchBottomTabStatus(int tabIndex) {
        switch (tabIndex) {
            case 0: {
                this.mTvMock.setTextColor(this.getResources().getColor(R.color.dk_color_337CC4));
                this.mTvTemplate.setTextColor(this.getResources().getColor(R.color.dk_color_333333));
                this.mIvMock.setImageResource(R.mipmap.dk_mock_highlight);
                this.mIvTemplate.setImageResource(R.mipmap.dk_template_normal);
                this.mInterceptRefreshLayout.setVisibility(0);
                this.mTemplateRefreshLayout.setVisibility(8);
                this.mSelectedTableIndex = BOTTOM_TAB_INDEX_0;
                if (this.mInterceptApiAdapter == null) break;
                this.mHomeTitleBar.setTitle(DoKitCommUtil.getString(R.string.dk_kit_network_mock) + "(" + this.mInterceptApiAdapter.getData().size() + ")");
                break;
            }
            case 1: {
                this.mTvMock.setTextColor(this.getResources().getColor(R.color.dk_color_333333));
                this.mTvTemplate.setTextColor(this.getResources().getColor(R.color.dk_color_337CC4));
                this.mIvMock.setImageResource(R.mipmap.dk_mock_normal);
                this.mIvTemplate.setImageResource(R.mipmap.dk_template_highlight);
                this.mInterceptRefreshLayout.setVisibility(8);
                this.mTemplateRefreshLayout.setVisibility(0);
                this.mSelectedTableIndex = BOTTOM_TAB_INDEX_1;
                if (this.mTemplateApiAdapter == null) {
                    this.initResponseApis(1);
                }
                if (this.mTemplateApiAdapter == null) break;
                this.mHomeTitleBar.setTitle(DoKitCommUtil.getString(R.string.dk_kit_network_mock) + "(" + this.mTemplateApiAdapter.getData().size() + ")");
                break;
            }
        }
        this.resetMenuStatus();
    }

    private void resetMenuStatus() {
        if (this.mSelectedTableIndex == BOTTOM_TAB_INDEX_0) {
            if (this.mInterceptFilterBean != null) {
                this.mGroupMenuAdapter.setCheckItem(this.mInterceptFilterBean.getGroupIndex());
                this.mSwitchMenuAdapter.setCheckItem(this.mInterceptFilterBean.getSwitchIndex());
                this.mDropDownMenu.resetTabText(new String[]{this.mGroupMenuAdapter.getList().get(this.mInterceptFilterBean.getGroupIndex()), this.mSwitchMenuAdapter.getList().get(this.mInterceptFilterBean.getSwitchIndex())});
                this.mEditText.setText((CharSequence)("" + this.mInterceptFilterBean.getFilterText()));
            }
        } else if (this.mSelectedTableIndex == BOTTOM_TAB_INDEX_1 && this.mTemplateFilterBean != null) {
            this.mGroupMenuAdapter.setCheckItem(this.mTemplateFilterBean.getGroupIndex());
            this.mSwitchMenuAdapter.setCheckItem(this.mTemplateFilterBean.getSwitchIndex());
            this.mDropDownMenu.resetTabText(new String[]{this.mGroupMenuAdapter.getList().get(this.mTemplateFilterBean.getGroupIndex()), this.mSwitchMenuAdapter.getList().get(this.mTemplateFilterBean.getSwitchIndex())});
            this.mEditText.setText((CharSequence)("" + this.mTemplateFilterBean.getFilterText()));
        }
        this.mDropDownMenu.closeMenu();
    }

    private static class FilterConditionBean {
        int groupIndex;
        int switchIndex;
        String filterText;

        private FilterConditionBean() {
        }

        public int getGroupIndex() {
            return this.groupIndex;
        }

        public void setGroupIndex(int groupIndex) {
            this.groupIndex = groupIndex;
        }

        public int getSwitchIndex() {
            return this.switchIndex;
        }

        public void setSwitchIndex(int switchIndex) {
            this.switchIndex = switchIndex;
        }

        public String getFilterText() {
            return this.filterText;
        }

        public void setFilterText(String filterText) {
            this.filterText = filterText;
        }

        public String toString() {
            return "FilterConditionBean{groupIndex=" + this.groupIndex + ", switchIndex=" + this.switchIndex + ", filterText='" + this.filterText + '\'' + '}';
        }
    }
}

